/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.util;

import com.qx.wz.external.fastjson.JSONException;
import com.qx.wz.external.fastjson.annotation.JSONCreator;
import com.qx.wz.external.fastjson.annotation.JSONField;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import com.qx.wz.external.fastjson.util.FieldInfo;
import com.qx.wz.external.fastjson.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DeserializeBeanInfo {
    private Constructor<?> defaultConstructor;
    private Constructor<?> creatorConstructor;
    private Method factoryMethod;
    private final List<FieldInfo> fieldList = new ArrayList<FieldInfo>();
    private final List<FieldInfo> sortedFieldList = new ArrayList<FieldInfo>();
    private int parserFeatures = 0;

    public DeserializeBeanInfo(Class<?> clazz) {
        this.parserFeatures = TypeUtils.getParserFeatures(clazz);
    }

    public static DeserializeBeanInfo computeSetters(Class<?> clazz, Type executable) {
        String string;
        int n2;
        DeserializeBeanInfo deserializeBeanInfo;
        DeserializeBeanInfo deserializeBeanInfo2 = deserializeBeanInfo;
        deserializeBeanInfo = new DeserializeBeanInfo(clazz);
        AccessibleObject[] accessibleObjectArray = DeserializeBeanInfo.getDefaultConstructor(clazz);
        if (accessibleObjectArray != null) {
            TypeUtils.setAccessible(accessibleObjectArray);
            deserializeBeanInfo2.setDefaultConstructor((Constructor<?>)accessibleObjectArray);
        } else if (accessibleObjectArray == null && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            executable = DeserializeBeanInfo.getCreatorConstructor(clazz);
            if (executable != null) {
                TypeUtils.setAccessible(executable);
                deserializeBeanInfo2.setCreatorConstructor((Constructor<?>)executable);
                for (int i3 = 0; i3 < ((Constructor)executable).getParameterTypes().length; ++i3) {
                    Annotation[] object = ((Constructor)executable).getParameterAnnotations()[i3];
                    JSONField jSONField = null;
                    for (Annotation annotation : object) {
                        if (!(annotation instanceof JSONField)) continue;
                        jSONField = (JSONField)annotation;
                        break;
                    }
                    if (jSONField != null) {
                        JSONField jSONField2 = jSONField;
                        Executable executable2 = executable;
                        Class<?> object2 = ((Constructor)executable2).getParameterTypes()[i3];
                        Type accessibleObject = ((Constructor)executable2).getGenericParameterTypes()[i3];
                        Field field = TypeUtils.getField(clazz, jSONField.name());
                        int n3 = jSONField2.ordinal();
                        int n4 = SerializerFeature.of(jSONField2.serialzeFeatures());
                        deserializeBeanInfo2.add(new FieldInfo(jSONField.name(), clazz, object2, accessibleObject, field, n3, n4));
                        continue;
                    }
                    throw new JSONException("illegal json creator");
                }
                return deserializeBeanInfo2;
            }
            executable = DeserializeBeanInfo.getFactoryMethod(clazz);
            if (executable != null) {
                TypeUtils.setAccessible(executable);
                deserializeBeanInfo2.setFactoryMethod((Method)executable);
                for (int i4 = 0; i4 < ((Method)executable).getParameterTypes().length; ++i4) {
                    Annotation[] annotationArray = ((Method)executable).getParameterAnnotations()[i4];
                    JSONField jSONField = null;
                    for (Annotation annotation : annotationArray) {
                        if (!(annotation instanceof JSONField)) continue;
                        jSONField = (JSONField)annotation;
                        break;
                    }
                    if (jSONField != null) {
                        JSONField jSONField3 = jSONField;
                        Executable executable3 = executable;
                        Class<?> clazz2 = ((Method)executable3).getParameterTypes()[i4];
                        Type type = ((Method)executable3).getGenericParameterTypes()[i4];
                        Field field = TypeUtils.getField(clazz, jSONField.name());
                        int n5 = jSONField3.ordinal();
                        int n6 = SerializerFeature.of(jSONField3.serialzeFeatures());
                        deserializeBeanInfo2.add(new FieldInfo(jSONField.name(), clazz, clazz2, type, field, n5, n6));
                        continue;
                    }
                    throw new JSONException("illegal json creator");
                }
                return deserializeBeanInfo2;
            }
            throw new JSONException("default constructor not found. " + clazz);
        }
        for (Method method : clazz.getMethods()) {
            FieldInfo fieldInfo;
            Object object;
            n2 = 0;
            int n7 = 0;
            string = method.getName();
            if (string.length() < 4 || Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE) && !method.getReturnType().equals(clazz) || method.getParameterTypes().length != 1) continue;
            Object object3 = method.getAnnotation(JSONField.class);
            if (object3 == null) {
                object3 = TypeUtils.getSupperMethodAnnotation(clazz, method);
            }
            if (object3 != null) {
                if (!object3.deserialize()) continue;
                JSONField jSONField = object3;
                n2 = jSONField.ordinal();
                n7 = SerializerFeature.of(jSONField.serialzeFeatures());
                if (jSONField.name().length() != 0) {
                    FieldInfo fieldInfo2;
                    string = object3.name();
                    object3 = fieldInfo2;
                    fieldInfo2 = new FieldInfo(string, method, null, clazz, (Type)((Object)executable), n2, n7);
                    deserializeBeanInfo2.add((FieldInfo)object3);
                    TypeUtils.setAccessible(method);
                    continue;
                }
            }
            if (!string.startsWith("set")) continue;
            char c3 = string.charAt(3);
            if (Character.isUpperCase(c3)) {
                string = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(string.substring(3)) : Character.toLowerCase(string.charAt(3)) + string.substring(4);
            } else if (c3 == '_') {
                string = string.substring(4);
            } else if (c3 == 'f') {
                string = string.substring(3);
            } else {
                if (string.length() < 5 || !Character.isUpperCase(string.charAt(4))) continue;
                string = TypeUtils.decapitalize(string.substring(3));
            }
            Object object4 = TypeUtils.getField(clazz, string);
            if (object4 == null && method.getParameterTypes()[0] == Boolean.TYPE) {
                object4 = TypeUtils.getField(clazz, "is" + Character.toUpperCase(string.charAt(0)) + string.substring(1));
            }
            if (object4 != null && (object = ((Field)object4).getAnnotation(JSONField.class)) != null) {
                JSONField jSONField = object;
                n2 = jSONField.ordinal();
                n7 = SerializerFeature.of(jSONField.serialzeFeatures());
                if (jSONField.name().length() != 0) {
                    FieldInfo fieldInfo3;
                    string = object.name();
                    object = fieldInfo3;
                    fieldInfo3 = new FieldInfo(string, method, (Field)object4, clazz, (Type)((Object)executable), n2, n7);
                    deserializeBeanInfo2.add((FieldInfo)object);
                    continue;
                }
            }
            object4 = fieldInfo;
            fieldInfo = new FieldInfo(string, method, null, clazz, (Type)((Object)executable), n2, n7);
            deserializeBeanInfo2.add((FieldInfo)object4);
            TypeUtils.setAccessible(method);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            FieldInfo fieldInfo;
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            n2 = 0;
            Iterator<FieldInfo> iterator = deserializeBeanInfo2.getFieldList().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getName().equals(((Field)accessibleObject).getName())) continue;
                n2 = 1;
            }
            if (n2 != 0) continue;
            AccessibleObject accessibleObject2 = accessibleObject;
            n2 = 0;
            int n8 = 0;
            string = ((Field)accessibleObject2).getName();
            Object object = ((Field)accessibleObject2).getAnnotation(JSONField.class);
            if (object != null) {
                JSONField jSONField = object;
                n2 = jSONField.ordinal();
                n8 = SerializerFeature.of(jSONField.serialzeFeatures());
                if (jSONField.name().length() != 0) {
                    string = object.name();
                }
            }
            object = fieldInfo;
            fieldInfo = new FieldInfo(string, null, (Field)accessibleObject, clazz, (Type)((Object)executable), n2, n8);
            deserializeBeanInfo2.add((FieldInfo)object);
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            FieldInfo fieldInfo;
            String string2 = ((Method)accessibleObject).getName();
            if (string2.length() < 4 || Modifier.isStatic(((Method)accessibleObject).getModifiers()) || !string2.startsWith("get") || !Character.isUpperCase(string2.charAt(3)) || ((Method)accessibleObject).getParameterTypes().length != 0 || !Collection.class.isAssignableFrom(((Method)accessibleObject).getReturnType()) && !Map.class.isAssignableFrom(((Method)accessibleObject).getReturnType())) continue;
            Object object = ((Method)accessibleObject).getAnnotation(JSONField.class);
            string2 = object != null && object.name().length() > 0 ? object.name() : Character.toLowerCase(string2.charAt(3)) + string2.substring(4);
            object = fieldInfo;
            fieldInfo = new FieldInfo(string2, (Method)accessibleObject, null, clazz, (Type)((Object)executable));
            deserializeBeanInfo2.add((FieldInfo)object);
            TypeUtils.setAccessible(accessibleObject);
        }
        return deserializeBeanInfo2;
    }

    /*
     * WARNING - void declaration
     */
    public static Constructor<?> getDefaultConstructor(Class<?> clazz) {
        void var4_9;
        Constructor<?>[] constructorArray;
        block7: {
            void object2;
            if (Modifier.isAbstract(clazz.getModifiers())) {
                return null;
            }
            Constructor<?>[] constructorArray2 = null;
            Constructor<?>[] constructorArray3 = clazz.getDeclaredConstructors();
            int n2 = constructorArray3.length;
            boolean i3 = false;
            while (object2 < n2) {
                constructorArray = constructorArray3[object2];
                if (constructorArray.getParameterTypes().length != 0) {
                    ++object2;
                    continue;
                }
                break block7;
            }
            constructorArray = constructorArray2;
        }
        if (constructorArray == null && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].equals(clazz.getDeclaringClass())) {
                    continue;
                }
                break;
            }
        } else {
            Constructor<?>[] constructorArray2 = constructorArray;
        }
        return var4_9;
    }

    /*
     * WARNING - void declaration
     */
    public static Constructor<?> getCreatorConstructor(Class<?> clazz) {
        void var4_6;
        block2: {
            Class<?> clazz2 = clazz;
            clazz = null;
            for (Constructor<?> genericDeclaration2 : clazz2.getDeclaredConstructors()) {
                if (genericDeclaration2.getAnnotation(JSONCreator.class) == null) {
                    continue;
                }
                break block2;
            }
            Class<?> clazz3 = clazz;
        }
        return var4_6;
    }

    public static Method getFactoryMethod(Class<?> clazz) {
        Method method3;
        block2: {
            Method method2 = null;
            for (Method method3 : clazz.getDeclaredMethods()) {
                if (!Modifier.isStatic(method3.getModifiers()) || !clazz.isAssignableFrom(method3.getReturnType()) || method3.getAnnotation(JSONCreator.class) == null) {
                    continue;
                }
                break block2;
            }
            method3 = method2;
        }
        return method3;
    }

    public Constructor<?> getDefaultConstructor() {
        return this.defaultConstructor;
    }

    public void setDefaultConstructor(Constructor<?> constructor) {
        this.defaultConstructor = constructor;
    }

    public Constructor<?> getCreatorConstructor() {
        return this.creatorConstructor;
    }

    public void setCreatorConstructor(Constructor<?> constructor) {
        this.creatorConstructor = constructor;
    }

    public Method getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(Method method) {
        this.factoryMethod = method;
    }

    public List<FieldInfo> getFieldList() {
        return this.fieldList;
    }

    public List<FieldInfo> getSortedFieldList() {
        return this.sortedFieldList;
    }

    public boolean add(FieldInfo fieldInfo) {
        for (FieldInfo fieldInfo2 : this.fieldList) {
            if (!fieldInfo2.getName().equals(fieldInfo.getName()) || fieldInfo2.isGetOnly() && !fieldInfo.isGetOnly()) continue;
            return false;
        }
        DeserializeBeanInfo deserializeBeanInfo = this;
        deserializeBeanInfo.fieldList.add(fieldInfo);
        deserializeBeanInfo.sortedFieldList.add(fieldInfo);
        Collections.sort(deserializeBeanInfo.sortedFieldList);
        return true;
    }

    public int getParserFeatures() {
        return this.parserFeatures;
    }
}

