/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.pop.util;

import com.qx.wz.exception.WzException;
import com.qx.wz.external.fastjson.JSON;
import com.qx.wz.pop.common.ServerErrorCode;
import com.qx.wz.pop.rpc.dto.Entity;
import com.qx.wz.pop.rpc.dto.EntityPoint;
import com.qx.wz.pop.rpc.dto.GLocationConfig;
import com.qx.wz.pop.rpc.result.Result;
import java.util.List;
import java.util.Map;

public class ApiCommonUtils {
    public static void validateParams(Object object, String string) {
        if (object != null) {
            return;
        }
        throw new WzException(ServerErrorCode.MISSING_PARAM.getCode(), string + " can't be null.");
    }

    public static Entity getEnityFromResult(Result result) {
        if (result.getData() != null) {
            return JSON.parseObject(result.getData().toString(), Entity.class);
        }
        return null;
    }

    public static List<Entity> getEntitiesFromResult(Result result) {
        if (result.getData() != null) {
            return JSON.parseArray(result.getData().toString(), Entity.class);
        }
        return null;
    }

    public static List<EntityPoint> getEntityPointsFromResult(Result result) {
        if (result.getData() != null) {
            return JSON.parseArray(result.getData().toString(), EntityPoint.class);
        }
        return null;
    }

    public static Map<String, Object> getAttributesFromResult(Result result) {
        if (result.getData() != null) {
            return JSON.parseObject(result.getData().toString(), Map.class);
        }
        return null;
    }

    public static GLocationConfig getConfigFromResult(Result result) {
        if (result.getData() != null) {
            return JSON.parseObject(result.getData().toString(), GLocationConfig.class);
        }
        return null;
    }

    public static Long getIdFromResult(Result result) {
        if (result.getData() != null) {
            return Long.parseLong(JSON.parseObject(result.getData().toString(), Map.class).get("id").toString());
        }
        return null;
    }
}

