/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.util;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class WzUtils {
    private static String TAG = "WzUtils";

    public static boolean setBluetoothAdapterEnable(boolean bl) {
        block6: {
            boolean bl2 = bl;
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            boolean bl3 = bluetoothAdapter.isEnabled();
            if (bl2 && !bl3) {
                return bluetoothAdapter.enable();
            }
            if (bl || !bl3) break block6;
            try {
                return bluetoothAdapter.disable();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isBluetoothAdapterAvailable() {
        boolean bl;
        block3: {
            bl = false;
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter == null) break block3;
            try {
                bl = bluetoothAdapter.isEnabled();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public static List<String> getPairedMagicBoxAddress() {
        List<String> list;
        block7: {
            Object object;
            block6: {
                block5: {
                    ArrayList<String> arrayList;
                    list = arrayList;
                    arrayList = new ArrayList<String>();
                    object = BluetoothAdapter.getDefaultAdapter();
                    if (object != null) break block5;
                    object = null;
                    break block6;
                }
                object = object.getBondedDevices();
            }
            if (object == null) break block7;
            if (object.size() <= 0) break block7;
            try {
                list = WzUtils.getPairedMagicBoxAddress((Set<BluetoothDevice>)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getPairedMagicBoxAddress(Set<BluetoothDevice> collection) {
        Iterator iterator;
        ArrayList arrayList;
        if (collection == null || collection.size() <= 0) return null;
        Collection<Object> collection2 = collection;
        collection = arrayList;
        arrayList = new ArrayList();
        try {
            iterator = collection2.iterator();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (true) {
            if (!iterator.hasNext()) return collection;
            BluetoothDevice bluetoothDevice = (BluetoothDevice)iterator.next();
            if (bluetoothDevice == null) continue;
            if (TextUtils.isEmpty((CharSequence)bluetoothDevice.getName())) continue;
            if (!bluetoothDevice.getName().contains("QX BeiDou Box")) continue;
            collection.add(bluetoothDevice.getAddress());
        }
        return collection;
    }

    public static Set<BluetoothDevice> getPairedBluetoothDevice() {
        BluetoothAdapter bluetoothAdapter;
        Set set;
        block3: {
            set = null;
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter != null) break block3;
            set = null;
        }
        try {
            set = bluetoothAdapter.getBondedDevices();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return set;
    }

    public static boolean isMagicBoxPaired(String string) {
        boolean bl;
        block7: {
            int n2;
            List<String> list;
            bl = false;
            if (TextUtils.isEmpty((CharSequence)string)) break block7;
            try {
                list = WzUtils.getPairedMagicBoxAddress();
                n2 = 0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            while (true) {
                if (n2 >= list.size()) break;
                if (string.equals(list.get(n2))) {
                    bl = true;
                    break;
                }
                ++n2;
                continue;
                break;
            }
        }
        return bl;
    }

    public static boolean isNetworkAvailable(Context context) {
        boolean bl;
        block4: {
            bl = false;
            if (context == null) {
                return false;
            }
            context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
            if (context == null) break block4;
            try {
                bl = context.isAvailable();
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public static String getIMEI(Context object) {
        if (object == null) {
            return "";
        }
        try {
            object = ((TelephonyManager)object.getSystemService("phone")).getDeviceId();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = "";
        }
        return object;
    }

    public static String getPhoneNumber(Context object) {
        block5: {
            if (object == null) {
                return "";
            }
            object = (TelephonyManager)object.getSystemService("phone");
            if (object.getLine1Number() != null) break block5;
            object = "";
        }
        try {
            object = object.getLine1Number();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = null;
        }
        return object;
    }

    public static String getExceptionMsg(Exception object) {
        PrintWriter printWriter;
        StringWriter stringWriter;
        if (object == null) {
            return null;
        }
        Exception exception = object;
        object = stringWriter;
        stringWriter = new StringWriter();
        PrintWriter printWriter2 = printWriter;
        exception.printStackTrace(new PrintWriter((Writer)object));
        String string = object.toString();
        printWriter2.close();
        return string;
    }

    public static String getThrowableMsg(Throwable object) {
        PrintWriter printWriter;
        StringWriter stringWriter;
        if (object == null) {
            return null;
        }
        Throwable throwable = object;
        object = stringWriter;
        stringWriter = new StringWriter();
        PrintWriter printWriter2 = printWriter;
        throwable.printStackTrace(new PrintWriter((Writer)object));
        String string = object.toString();
        printWriter2.close();
        return string;
    }

    public static String getAppKey(Context object) {
        block7: {
            if (object == null) {
                return "";
            }
            object = object.getPackageManager().getPackageInfo(object.getPackageName(), 16512);
            if (object == null) break block7;
            if (((PackageInfo)object).applicationInfo == null) break block7;
            if (((PackageInfo)object).applicationInfo.metaData == null) break block7;
            object = ((PackageInfo)object).applicationInfo.metaData.get("com.pop.api.appKey");
            if (object == null) break block7;
            try {
                return object.toString();
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
        }
        return "";
    }

    public static long getExternalStorageAvailaleSize() {
        StatFs statFs;
        File file = Environment.getExternalStorageDirectory();
        StatFs statFs2 = statFs;
        statFs = new StatFs(file.getPath());
        long l2 = Build.VERSION.SDK_INT >= 18 ? statFs2.getBlockSizeLong() : (long)statFs2.getBlockSize();
        return (Build.VERSION.SDK_INT >= 18 ? statFs2.getAvailableBlocksLong() : (long)statFs2.getAvailableBlocks()) * l2;
    }

    public static long getExternalStorageTotalSize() {
        StatFs statFs;
        File file = Environment.getExternalStorageDirectory();
        StatFs statFs2 = statFs;
        statFs = new StatFs(file.getPath());
        long l2 = Build.VERSION.SDK_INT >= 18 ? statFs2.getBlockSizeLong() : (long)statFs2.getBlockSize();
        return (Build.VERSION.SDK_INT >= 18 ? statFs2.getBlockCountLong() : (long)statFs2.getBlockCount()) * l2;
    }

    public static String getExternalStoragePath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public static void sleepInMillis(long l2) {
        try {
            Thread.sleep(l2);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static ArrayList<Integer> getCellIdList(Context context) {
        if ((context = (TelephonyManager)context.getSystemService("phone")) == null) {
            return null;
        }
        return WzUtils.toCellIdList(context.getAllCellInfo());
    }

    private static ArrayList<Integer> toCellIdList(List<CellInfo> arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<Integer> arrayList2;
            ArrayList<Integer> arrayList3 = arrayList;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<Integer>();
            for (CellInfo cellInfo : arrayList3) {
                if (cellInfo instanceof CellInfoGsm) {
                    arrayList.add(((CellInfoGsm)cellInfo).getCellIdentity().getCid());
                }
                if (cellInfo instanceof CellInfoLte) {
                    arrayList.add(((CellInfoLte)cellInfo).getCellIdentity().getCi());
                }
                if (cellInfo instanceof CellInfoWcdma) {
                    arrayList.add(((CellInfoWcdma)cellInfo).getCellIdentity().getCid());
                }
                if (!(cellInfo instanceof CellInfoCdma)) continue;
                arrayList.add(((CellInfoCdma)cellInfo).getCellIdentity().getBasestationId());
            }
            return arrayList;
        }
        return null;
    }

    public static String getOperator(Context object) {
        Context context = object;
        object = null;
        Object object2 = (TelephonyManager)context.getSystemService("phone");
        if (object2 != null) {
            if (TextUtils.isEmpty((CharSequence)(object2 = object2.getSimOperator()))) {
                object = "unknow";
            } else if (!((String)object2).equals("46000") && !((String)object2).equals("46002")) {
                if (((String)object2).equals("46001")) {
                    object = "China Unicom";
                } else if (((String)object2).equals("46003")) {
                    object = "China Telecom";
                }
            } else {
                object = "China Mobile";
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static String getPhoneType(Context object) {
        void var0_6;
        Object var0_1 = null;
        TelephonyManager telephonyManager = (TelephonyManager)object.getSystemService("phone");
        if (telephonyManager == null) return var0_6;
        switch (telephonyManager.getPhoneType()) {
            default: {
                return var0_6;
            }
            case 3: {
                return var0_6;
            }
            case 2: {
                return var0_6;
            }
            case 1: {
                return var0_6;
            }
            case 0: 
        }
        return var0_6;
    }
}

