/*
 * Decompiled with CFR 0.152.
 */
package com.bosch.mtprotocol.glm100C;

import com.bosch.mtprotocol.MtConnection;
import com.bosch.mtprotocol.MtFrameFactory;
import com.bosch.mtprotocol.MtMessage;
import com.bosch.mtprotocol.MtMessageFactory;
import com.bosch.mtprotocol.MtProtocol;
import com.bosch.mtprotocol.glm100C.MtFrameConstants;
import com.bosch.mtprotocol.glm100C.MtTimer;
import com.bosch.mtprotocol.glm100C.connection.MtAsyncBLEConnection;
import com.bosch.mtprotocol.glm100C.event.MtProtocolFatalErrorEvent;
import com.bosch.mtprotocol.glm100C.event.MtProtocolReceiveMessageEvent;
import com.bosch.mtprotocol.glm100C.event.MtProtocolRequestTimeoutEvent;
import com.bosch.mtprotocol.glm100C.frame.MtBaseFrame;
import com.bosch.mtprotocol.glm100C.frame.MtFrameByteReader;
import com.bosch.mtprotocol.glm100C.frame.MtRequestFrame;
import com.bosch.mtprotocol.glm100C.message.FrameFactoryImpl;
import com.bosch.mtprotocol.glm100C.message.MessageFactoryImpl;
import com.bosch.mtprotocol.glm100C.state.MtProtocolStateMachine;
import com.bosch.mtprotocol.glm100C.state.MtProtocolStates;
import com.bosch.mtprotocol.util.statemachine.StateMachine;
import com.bosch.mtprotocol.util.statemachine.exc.StateMachineDescriptorException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Logger;

public class MtProtocolBLEImpl
implements MtProtocol,
MtFrameConstants,
MtTimer.MtTimerListener,
MtProtocolStates,
MtAsyncBLEConnection.MTAsyncBLEConnectionCallbackRecipient {
    private static final Logger LOG = Logger.getLogger(MtProtocol.class.getName());
    private static final int RX_FIFO_SIZE = 25;
    private static final int TX_FIFO_SIZE = 25;
    private StateMachine stateMachine;
    private MtAsyncBLEConnection connection;
    private MtFrameByteReader frameReader;
    private MtRequestFrame currentRequest;
    private ArrayList<MtMessage> messages;
    private LinkedBlockingDeque<MtMessage> outgoingDeque;
    private Set<MtProtocol.MTProtocolEventObserver> observers;
    private int timeout;
    private MtTimer timeoutTimer;
    private MtFrameFactory frameFactory;
    private MtMessageFactory messageFactory;
    private boolean flagIsBLEWriteFinished;
    private SendThread sendThread;

    public MtProtocolBLEImpl() {
        MessageFactoryImpl messageFactoryImpl;
        FrameFactoryImpl frameFactoryImpl;
        HashSet hashSet;
        LinkedBlockingDeque linkedBlockingDeque;
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.messages = object;
        object = linkedBlockingDeque;
        linkedBlockingDeque = new LinkedBlockingDeque();
        v1.outgoingDeque = object;
        object = hashSet;
        hashSet = new HashSet();
        v1.observers = object;
        object = frameFactoryImpl;
        frameFactoryImpl = new FrameFactoryImpl();
        v1.frameFactory = object;
        object = messageFactoryImpl;
        messageFactoryImpl = new MessageFactoryImpl();
        v1.messageFactory = object;
        v1.flagIsBLEWriteFinished = true;
    }

    private void notifyObservers(MtProtocol.MTProtocolEvent mTProtocolEvent) {
        Iterator<MtProtocol.MTProtocolEventObserver> iterator = ((MtProtocolBLEImpl)((Object)iterator)).observers.iterator();
        while (iterator.hasNext()) {
            ((MtProtocol.MTProtocolEventObserver)iterator.next()).onEvent(mTProtocolEvent);
        }
    }

    private void checkMessageComplete() {
        LOG.finest("MtProtocol: Frame receive complete");
        if (this.frameReader.getComStatus() == 0) {
            Object object;
            MtProtocolBLEImpl mtProtocolBLEImpl = this;
            MtBaseFrame mtBaseFrame = (MtBaseFrame)mtProtocolBLEImpl.frameReader.getFrame();
            if (mtProtocolBLEImpl.stateMachine.getCurrentState() == "MASTER_RECEIVING" && mtBaseFrame.getCommand() == 0) {
                object = this.currentRequest;
                if (object != null) {
                    mtBaseFrame.setCommand(((MtBaseFrame)object).getCommand());
                } else {
                    LOG.warning("Unknown response received! Current request is NULL");
                }
            }
            object = null;
            try {
                object = this.messageFactory.createMessage(mtBaseFrame);
            }
            catch (Exception exception) {}
            this.messages.add((MtMessage)object);
        } else {
            MtProtocolBLEImpl mtProtocolBLEImpl = this;
            LOG.warning("MtProtocol: Communication error");
            mtProtocolBLEImpl.notifyObservers(new MtProtocolFatalErrorEvent());
            mtProtocolBLEImpl.notify();
        }
    }

    private synchronized void checkTransactionCompleted() {
        MtFrameByteReader mtFrameByteReader = this.frameReader;
        if (mtFrameByteReader != null && mtFrameByteReader.isFrameRcvComplete()) {
            block10: {
                MtProtocolBLEImpl mtProtocolBLEImpl = this;
                LOG.finest("MtProtocol: Buffer receive complete or timeout");
                mtProtocolBLEImpl.stopTimeoutTimer();
                mtProtocolBLEImpl.stateMachine.processEvent("RECEIVE_FINISH");
                if (!mtProtocolBLEImpl.outgoingDeque.isEmpty()) break block10;
                if (this.stateMachine.getCurrentState() != "MASTER_READY") break block10;
                try {
                    this.stateMachine.processEvent("SWITCH_TO_SLAVE");
                }
                catch (StateMachineDescriptorException stateMachineDescriptorException) {
                    stateMachineDescriptorException.printStackTrace();
                }
            }
            for (MtMessage mtMessage : this.messages) {
                if (mtMessage == null) {
                    LOG.finest("Error occurred when turning received frame to message");
                    this.notifyObservers(new MtProtocolFatalErrorEvent());
                } else {
                    MtProtocolBLEImpl mtProtocolBLEImpl = this;
                    LOG.finest("Received message: " + mtMessage);
                    mtProtocolBLEImpl.notifyObservers(new MtProtocolReceiveMessageEvent(mtMessage));
                    SendThread sendThread = mtProtocolBLEImpl.sendThread;
                    if (sendThread != null) {
                        sendThread.stopTimeoutTimer();
                    }
                }
                this.notify();
            }
            this.messages.clear();
            this.frameReader = null;
        } else {
            LOG.warning("MtProtocol: Frame receive not complete");
        }
    }

    private synchronized void sendingCompleted() {
        this.flagIsBLEWriteFinished = true;
        this.notify();
    }

    private void startTimeoutTimer() {
        MtTimer mtTimer;
        MtTimer mtTimer2;
        MtProtocolBLEImpl mtProtocolBLEImpl = this;
        mtProtocolBLEImpl.stopTimeoutTimer();
        MtTimer mtTimer3 = mtTimer2 = mtTimer;
        mtTimer3(this.timeout);
        this.timeoutTimer = mtTimer3;
        mtTimer.setListener(this);
        mtProtocolBLEImpl.timeoutTimer.start();
    }

    private void stopTimeoutTimer() {
        MtTimer mtTimer = this.timeoutTimer;
        if (mtTimer != null) {
            mtTimer.setListener(null);
            this.timeoutTimer.stop();
            this.timeoutTimer = null;
        }
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }

    static /* synthetic */ SendThread access$300(MtProtocolBLEImpl mtProtocolBLEImpl) {
        return mtProtocolBLEImpl.sendThread;
    }

    static /* synthetic */ LinkedBlockingDeque access$400(MtProtocolBLEImpl mtProtocolBLEImpl) {
        return mtProtocolBLEImpl.outgoingDeque;
    }

    static /* synthetic */ StateMachine access$500(MtProtocolBLEImpl mtProtocolBLEImpl) {
        return mtProtocolBLEImpl.stateMachine;
    }

    static /* synthetic */ MtFrameFactory access$600(MtProtocolBLEImpl mtProtocolBLEImpl) {
        return mtProtocolBLEImpl.frameFactory;
    }

    static /* synthetic */ MtRequestFrame access$702(MtProtocolBLEImpl mtProtocolBLEImpl, MtRequestFrame mtRequestFrame) {
        mtProtocolBLEImpl.currentRequest = mtRequestFrame;
        return mtRequestFrame;
    }

    static /* synthetic */ MtAsyncBLEConnection access$800(MtProtocolBLEImpl mtProtocolBLEImpl) {
        return mtProtocolBLEImpl.connection;
    }

    static /* synthetic */ boolean access$902(MtProtocolBLEImpl mtProtocolBLEImpl, boolean bl) {
        mtProtocolBLEImpl.flagIsBLEWriteFinished = bl;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onTimerTick() {
        v0 = this;
        v0.stateMachine.processEvent("SET_TIMEOUT");
        if (v0.frameReader == null) ** GOTO lbl16
        var1_1 = this.frameReader;
        v1 = this;
        // MONITORENTER : var1_1
        try {
            v1.frameReader = null;
            // MONITOREXIT : var1_1
            ** GOTO lbl16
        }
        catch (Throwable v2) {
            // MONITOREXIT : var1_1
            throw v2;
lbl16:
            // 2 sources

            if (this.stateMachine.getCurrentState() != "MASTER_READY") ** GOTO lbl19
            try {
                this.stateMachine.processEvent("SWITCH_TO_SLAVE");
lbl19:
                // 2 sources

                this.notifyObservers(new MtProtocolRequestTimeoutEvent());
                return;
            }
            catch (StateMachineDescriptorException v3) {
                v3.printStackTrace();
            }
        }
    }

    @Override
    public void initialize(MtConnection object) {
        Throwable throwable;
        LOG.warning("Initializing MT Protocol...");
        ((MtProtocolBLEImpl)((Object)throwable2)).stateMachine = new MtProtocolStateMachine();
        if (object instanceof MtAsyncBLEConnection) {
            MtProtocolBLEImpl mtProtocolBLEImpl = throwable2;
            mtProtocolBLEImpl.connection = (MtAsyncBLEConnection)object;
            LOG.warning("Adding as observer...");
            mtProtocolBLEImpl.connection.addCallbackRecipient((MtAsyncBLEConnection.MTAsyncBLEConnectionCallbackRecipient)((Object)throwable2));
            mtProtocolBLEImpl.frameReader = null;
            mtProtocolBLEImpl.currentRequest = null;
            mtProtocolBLEImpl.messages.clear();
            mtProtocolBLEImpl.outgoingDeque.clear();
            object = mtProtocolBLEImpl.sendThread;
            if (object != null) {
                ((Thread)object).interrupt();
            }
            ((MtProtocolBLEImpl)((Object)throwable2)).sendThread = (MtProtocolBLEImpl)((Object)throwable2).new SendThread();
            ((MtProtocolBLEImpl)((Object)throwable2)).sendThread.start();
            try {
                ((MtProtocolBLEImpl)((Object)throwable2)).stateMachine.processEvent("INITIALIZE_SLAVE");
                return;
            }
            catch (StateMachineDescriptorException stateMachineDescriptorException) {
                throw new RuntimeException("Can't initialize MTProtocol", stateMachineDescriptorException);
            }
        }
        Throwable throwable2 = throwable;
        throwable = new Throwable();
        throw new RuntimeException("Can't initialize MTProtocol", throwable2);
    }

    @Override
    public void destroy() {
        MtProtocolBLEImpl mtProtocolBLEImpl = this;
        mtProtocolBLEImpl.connection.removeCallbackRecipient(this);
        mtProtocolBLEImpl.observers.clear();
        SendThread sendThread = mtProtocolBLEImpl.sendThread;
        if (sendThread != null) {
            sendThread.stopTimeoutTimer();
            this.sendThread.interrupt();
        }
    }

    @Override
    public void sendMessage(MtMessage mtMessage) {
        if (this.stateMachine.getCurrentState() == "SLAVE_LISTENING") {
            try {
                this.stateMachine.processEvent("SWITCH_TO_MASTER");
            }
            catch (StateMachineDescriptorException stateMachineDescriptorException) {
                stateMachineDescriptorException.printStackTrace();
                return;
            }
        }
        LOG.finest("MtProtocol: Adding outgoing message to queue.");
        if (this.outgoingDeque.offer(mtMessage)) {
            return;
        }
        throw new RuntimeException("MtProtocol: Error: outgoing queue is full, message dropped.");
    }

    @Override
    public void addObserver(MtProtocol.MTProtocolEventObserver mTProtocolEventObserver) {
        this.observers.add(mTProtocolEventObserver);
    }

    @Override
    public void removeObserver(MtProtocol.MTProtocolEventObserver mTProtocolEventObserver) {
        this.observers.remove(mTProtocolEventObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onBLECharacteristicChanged(byte[] byArray) {
        MtProtocolBLEImpl mtProtocolBLEImpl = this;
        int n2 = byArray.length;
        mtProtocolBLEImpl.startTimeoutTimer();
        LOG.warning("BLE callback in MTProtocol; Bytes in buffer: " + n2);
        if (mtProtocolBLEImpl.stateMachine.getCurrentState() == "SLAVE_LISTENING") {
            try {
                this.stateMachine.processEvent("RECEIVE_START");
            }
            catch (StateMachineDescriptorException stateMachineDescriptorException) {
                stateMachineDescriptorException.printStackTrace();
            }
        }
        if (this.stateMachine.getCurrentState() != "SLAVE_RECEIVING" && this.stateMachine.getCurrentState() != "MASTER_RECEIVING") {
            LOG.warning("MtProtocolImpl: Ignoring received data; Current state: " + this.stateMachine.getCurrentState());
        } else {
            if (this.frameReader == null) {
                this.frameReader = new MtFrameByteReader(new byte[25], 25);
            }
            MtFrameByteReader mtFrameByteReader = this.frameReader;
            synchronized (mtFrameByteReader) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    MtProtocolBLEImpl mtProtocolBLEImpl2 = this;
                    byte by = byArray[i3];
                    mtProtocolBLEImpl2.frameReader.append(by);
                    if (!mtProtocolBLEImpl2.frameReader.isFrameRcvComplete()) continue;
                    this.checkMessageComplete();
                    if (i3 < n2 - 1) {
                        MtProtocolBLEImpl mtProtocolBLEImpl3 = this;
                        LOG.warning("Frame was not last frame in buffer; expect another frame");
                        mtProtocolBLEImpl3.frameReader = null;
                        mtProtocolBLEImpl3.frameReader = new MtFrameByteReader(new byte[25], 25);
                        continue;
                    }
                    LOG.warning("Frame was last frame in buffer; proceed to transaction completion");
                    continue;
                }
            }
        }
        this.checkTransactionCompleted();
        return;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    @Override
    public void onBLEWriteFinished(int n2) {
        if (n2 == 0) {
            this.sendingCompleted();
        }
    }

    @Override
    public void reset() {
        MtProtocolBLEImpl mtProtocolBLEImpl = this;
        mtProtocolBLEImpl.initialize(mtProtocolBLEImpl.connection);
    }

    @Override
    public void setTimeout(int n2) {
        this.timeout = n2;
    }

    private class SendThread
    extends Thread {
        private MtTimer timeoutTimer;

        private SendThread() {
        }

        private synchronized void startTimeoutTimer() {
            MtTimer mtTimer;
            MtTimer mtTimer2;
            SendThread sendThread = this;
            sendThread.stopTimeoutTimer();
            MtTimer mtTimer3 = mtTimer2 = mtTimer;
            mtTimer3(MtProtocolBLEImpl.this.timeout);
            this.timeoutTimer = mtTimer3;
            mtTimer.setListener(MtProtocolBLEImpl.this);
            sendThread.timeoutTimer.start();
        }

        private synchronized void stopTimeoutTimer() {
            MtTimer mtTimer = this.timeoutTimer;
            if (mtTimer != null) {
                mtTimer.setListener(null);
                this.timeoutTimer.stop();
                this.timeoutTimer = null;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

