/*
 * Decompiled with CFR 0.152.
 */
package com.bosch.mtprotocol.glm100C.frame;

import com.bosch.mtprotocol.MtFrame;
import com.bosch.mtprotocol.glm100C.MtFrameConstants;
import com.bosch.mtprotocol.type.UnionFloat;
import com.bosch.mtprotocol.type.UnionUint16;
import com.bosch.mtprotocol.type.UnionUint32;
import com.bosch.mtprotocol.type.field.Field;
import java.nio.ByteBuffer;
import java.util.Iterator;

public abstract class MtBaseFrame
implements MtFrame,
MtFrameConstants {
    private byte ui8Command;
    private ByteBuffer payloadData;
    private byte[] rawData;

    public MtBaseFrame(int n2) {
        this.payloadData = ByteBuffer.allocate(n2);
    }

    public byte getCommand() {
        return this.ui8Command;
    }

    public void setCommand(byte by) {
        this.ui8Command = by;
    }

    public byte[] getPayloadData() {
        int n2 = this.payloadData.position();
        byte[] byArray = new byte[n2];
        MtBaseFrame mtBaseFrame = this;
        mtBaseFrame.payloadData.position(0);
        mtBaseFrame.payloadData.get(byArray, 0, n2);
        return byArray;
    }

    public void pushUint8ToData(byte by) {
        this.payloadData.put(by);
    }

    public void pushUint16ToData(short s2) {
        UnionUint16 unionUint16 = new UnionUint16();
        unionUint16.setShort(s2);
        for (Field field : unionUint16) {
            this.payloadData.put(field.getByte());
        }
    }

    public void pushUint32ToData(int n2) {
        UnionUint32 unionUint32 = new UnionUint32();
        unionUint32.setValue(n2);
        for (Field field : unionUint32) {
            this.payloadData.put(field.getByte());
        }
    }

    public void reset() {
        this.payloadData.position(0);
    }

    public byte popUint8FromPayloadData() {
        return this.payloadData.get();
    }

    public float popFloatFromPayloadData() {
        UnionFloat unionFloat;
        UnionFloat unionFloat2 = unionFloat;
        Iterator iterator = new UnionFloat().iterator();
        while (iterator.hasNext()) {
            ((Field)iterator.next()).setValue(this.payloadData.get());
        }
        return unionFloat2.getFloat();
    }

    public int popUint32FromPayloadData() {
        UnionUint32 unionUint32;
        UnionUint32 unionUint322 = unionUint32;
        Iterator iterator = new UnionUint32().iterator();
        while (iterator.hasNext()) {
            ((Field)iterator.next()).setValue(this.payloadData.get());
        }
        return unionUint322.getValue();
    }

    public int popUint16FromPayloadData() {
        UnionUint16 unionUint16;
        UnionUint16 unionUint162 = unionUint16;
        Iterator iterator = new UnionUint16().iterator();
        while (iterator.hasNext()) {
            ((Field)iterator.next()).setValue(this.payloadData.get());
        }
        return unionUint162.getShort();
    }

    @Override
    public byte[] getRawData() {
        Object object = ((MtBaseFrame)object).rawData;
        if (((MtBaseFrame)object).rawData == null) {
            return new byte[0];
        }
        return object;
    }

    public void setRawData(byte[] byArray) {
        this.rawData = byArray;
    }
}

