/*
 * Decompiled with CFR 0.152.
 */
package com.bosch.mtprotocol.glm100C.frame;

import com.bosch.mtprotocol.MtFrame;
import com.bosch.mtprotocol.glm100C.MtFrameConstants;
import com.bosch.mtprotocol.glm100C.frame.MtRequestFrame;
import com.bosch.mtprotocol.glm100C.frame.MtResponseFrame;
import com.bosch.mtprotocol.type.UnionFrameMode;
import com.bosch.mtprotocol.type.UnionStatusByte;
import com.bosch.mtprotocol.type.UnionUint16;
import com.bosch.mtprotocol.util.CastUtil;
import com.bosch.mtprotocol.util.Crc;

public class MtFrameByteReader
implements MtFrameConstants {
    private RxState rxState;
    private MtFrame frame;
    private UnionStatusByte unStatusByte;
    private UnionFrameMode unFrameMode;
    private byte ui8Command;
    private byte ui8CrcLsb;
    private byte ui8CrcB2;
    private byte ui8CrcB3;
    private int rxFrameFormat;
    private boolean boMsgRcvComplete;
    private int ui32RxCrc;
    private UnionUint16 unNumRxPayloadBytes;
    private final int ui16RxFifoSize;
    private final byte[] arrui8RxFifo;
    private int ui16RxFifoWritePos;
    private int frameType;

    public MtFrameByteReader(byte[] byArray, int n2) {
        MtFrameByteReader mtFrameByteReader = this;
        this.unStatusByte = new UnionStatusByte();
        this.unFrameMode = new UnionFrameMode();
        this.unNumRxPayloadBytes = new UnionUint16();
        this.ui16RxFifoSize = n2;
        mtFrameByteReader.arrui8RxFifo = byArray;
        mtFrameByteReader.ui16RxFifoWritePos = 0;
        mtFrameByteReader.ui8Command = 0;
        mtFrameByteReader.rxState = RxState.STATE_INIT;
        mtFrameByteReader.ui32RxCrc = Crc.EN_CRC32_INITIAL_VALUE;
    }

    private void setFrameMode(int n2) {
        MtFrameByteReader mtFrameByteReader = this;
        mtFrameByteReader.unFrameMode.setValue(n2);
        this.rxFrameFormat = mtFrameByteReader.frameType == 0 ? this.unFrameMode.ui2ResponseFrameFormat.getValue() : this.unFrameMode.ui2RequestFrameFormat.getValue();
    }

    public void append(byte by) {
        int n2;
        int n3 = 0;
        if (this.rxState == RxState.STATE_INIT) {
            this.frameType = n2 = (by & 0xFF) >>> 6;
            this.rxState = n2 == 3 ? RxState.STATE_MODE : (n2 == 0 ? RxState.STATE_STATUS : RxState.STATE_ERROR);
        }
        switch (1.$SwitchMap$com$bosch$mtprotocol$glm100C$frame$MtFrameByteReader$RxState[this.rxState.ordinal()]) {
            default: {
                break;
            }
            case 10: {
                MtFrameByteReader mtFrameByteReader = this;
                mtFrameByteReader.ui32RxCrc = n3 = Crc.calcCrc32(by, this.ui32RxCrc);
                mtFrameByteReader.ui32RxCrc = n3 = Crc.calcCrc32(mtFrameByteReader.ui8CrcB3, n3);
                mtFrameByteReader.ui32RxCrc = n3 = Crc.calcCrc32(mtFrameByteReader.ui8CrcB2, n3);
                mtFrameByteReader.ui32RxCrc = Crc.calcCrc32(mtFrameByteReader.ui8CrcLsb, n3);
                n3 = 1;
                break;
            }
            case 9: {
                MtFrameByteReader mtFrameByteReader = this;
                mtFrameByteReader.ui8CrcB3 = by;
                mtFrameByteReader.rxState = RxState.STATE_CRC_MSB;
                break;
            }
            case 8: {
                MtFrameByteReader mtFrameByteReader = this;
                mtFrameByteReader.ui8CrcB2 = by;
                mtFrameByteReader.rxState = RxState.STATE_CRC_BYTE3;
                break;
            }
            case 7: {
                if (this.rxFrameFormat == 2) {
                    MtFrameByteReader mtFrameByteReader = this;
                    mtFrameByteReader.ui8CrcLsb = by;
                    mtFrameByteReader.rxState = RxState.STATE_CRC_BYTE2;
                    break;
                }
                this.ui32RxCrc = CastUtil.uByteToInt(Crc.calcCrc8(by, (byte)this.ui32RxCrc));
                n3 = 1;
                break;
            }
            case 6: {
                if (this.ui16RxFifoWritePos >= this.unNumRxPayloadBytes.getValue()) break;
                n2 = this.ui16RxFifoWritePos;
                if (n2 < this.ui16RxFifoSize) {
                    int n4;
                    byte[] byArray = this.arrui8RxFifo;
                    this.ui16RxFifoWritePos = n4 = n2 + 1;
                    byArray[n2] = by;
                    if (n4 != this.unNumRxPayloadBytes.getValue()) break;
                    this.rxState = RxState.STATE_CRC_LSB;
                    break;
                }
                this.unStatusByte.ui3ComStatus.setValue(6);
                this.rxState = RxState.STATE_ERROR;
                break;
            }
            case 5: {
                MtFrameByteReader mtFrameByteReader = this;
                mtFrameByteReader.unNumRxPayloadBytes.ui8MSB.setValue(by);
                if (mtFrameByteReader.unNumRxPayloadBytes.getValue() == 0) {
                    this.rxState = RxState.STATE_CRC_LSB;
                    break;
                }
                this.rxState = RxState.STATE_DATA;
                break;
            }
            case 4: {
                MtFrameByteReader mtFrameByteReader = this;
                mtFrameByteReader.unNumRxPayloadBytes.ui8LSB.setValue(by);
                if (mtFrameByteReader.rxFrameFormat == 2) {
                    this.rxState = RxState.STATE_SIZE_MSB;
                    break;
                }
                if (this.unNumRxPayloadBytes.getValue() == 0) {
                    this.rxState = RxState.STATE_CRC_LSB;
                    break;
                }
                this.rxState = RxState.STATE_DATA;
                break;
            }
            case 3: {
                this.ui8Command = by;
                if (this.rxFrameFormat == 1) {
                    this.rxState = RxState.STATE_CRC_LSB;
                    break;
                }
                this.rxState = RxState.STATE_SIZE_LSB;
                break;
            }
            case 2: {
                MtFrameByteReader mtFrameByteReader = this;
                mtFrameByteReader.unStatusByte.setValue(by);
                if ((mtFrameByteReader.unStatusByte.ui3ComStatus.getValue() & 3) > 0) {
                    this.rxFrameFormat = 0;
                }
                if (this.unStatusByte.ui2FrameType.getValue() == 0) {
                    n2 = this.rxFrameFormat;
                    if (n2 != 0) {
                        if (n2 != 2) {
                            this.rxState = RxState.STATE_CRC_LSB;
                            break;
                        }
                        this.rxState = RxState.STATE_CMD;
                        break;
                    }
                    this.rxState = RxState.STATE_SIZE_LSB;
                    break;
                }
                this.rxState = RxState.STATE_ERROR;
                break;
            }
            case 1: {
                MtFrameByteReader mtFrameByteReader = this;
                mtFrameByteReader.setFrameMode(by);
                this.rxState = mtFrameByteReader.unFrameMode.ui2FrameType.getValue() == 3 ? RxState.STATE_CMD : RxState.STATE_ERROR;
            }
        }
        if (n3 != 0) {
            if (this.ui32RxCrc == 0) {
                MtFrameByteReader mtFrameByteReader = this;
                mtFrameByteReader.boMsgRcvComplete = true;
                mtFrameByteReader.rxState = RxState.STATE_INIT;
            } else {
                this.unStatusByte.ui3ComStatus.setValue(3);
                this.rxState = RxState.STATE_ERROR;
            }
        } else if (this.rxFrameFormat == 2) {
            RxState rxState = this.rxState;
            if (rxState != RxState.STATE_CRC_BYTE2 && rxState != RxState.STATE_CRC_BYTE3 && rxState != RxState.STATE_CRC_MSB) {
                this.ui32RxCrc = Crc.calcCrc32(by, this.ui32RxCrc);
            }
        } else {
            this.ui32RxCrc = CastUtil.uByteToInt(Crc.calcCrc8(by, (byte)this.ui32RxCrc));
        }
    }

    public synchronized boolean isFrameRcvComplete() {
        return this.boMsgRcvComplete;
    }

    public synchronized void clearFrameRcvComplete() {
        this.boMsgRcvComplete = false;
    }

    public int getComStatus() {
        return this.unStatusByte.ui3ComStatus.getValue();
    }

    public MtFrame getFrame() {
        MtFrame mtFrame = this.frame;
        if (mtFrame != null) {
            return mtFrame;
        }
        if (this.isFrameRcvComplete()) {
            int n2 = this.frameType;
            if (n2 == 3) {
                MtRequestFrame mtRequestFrame;
                MtRequestFrame mtRequestFrame2 = mtRequestFrame;
                mtRequestFrame2(this.ui16RxFifoSize);
                mtRequestFrame2.setCommand(this.ui8Command);
                mtRequestFrame.setFrameMode(this.unFrameMode.getValue());
                for (int i3 = 0; i3 < this.unNumRxPayloadBytes.getValue(); ++i3) {
                    mtRequestFrame2.pushUint8ToData(this.arrui8RxFifo[i3]);
                }
                this.frame = mtRequestFrame2;
            } else if (n2 == 0) {
                MtResponseFrame mtResponseFrame;
                MtResponseFrame mtResponseFrame2 = mtResponseFrame;
                mtResponseFrame2(this.ui16RxFifoSize);
                mtResponseFrame2.setCommand(this.ui8Command);
                mtResponseFrame2.setStatusByte(this.unStatusByte);
                mtResponseFrame.setFrameFormat(this.rxFrameFormat);
                for (int i4 = 0; i4 < this.unNumRxPayloadBytes.getValue(); ++i4) {
                    mtResponseFrame2.pushUint8ToData(this.arrui8RxFifo[i4]);
                }
                this.frame = mtResponseFrame2;
            }
        }
        return this.frame;
    }

    static final class RxState
    extends Enum<RxState> {
        public static final /* enum */ RxState STATE_INIT;
        public static final /* enum */ RxState STATE_MODE;
        public static final /* enum */ RxState STATE_STATUS;
        public static final /* enum */ RxState STATE_CMD;
        public static final /* enum */ RxState STATE_SIZE_LSB;
        public static final /* enum */ RxState STATE_SIZE_MSB;
        public static final /* enum */ RxState STATE_DATA;
        public static final /* enum */ RxState STATE_CRC_LSB;
        public static final /* enum */ RxState STATE_CRC_BYTE2;
        public static final /* enum */ RxState STATE_CRC_BYTE3;
        public static final /* enum */ RxState STATE_CRC_MSB;
        public static final /* enum */ RxState STATE_ERROR;
        private static final /* synthetic */ RxState[] $VALUES;

        public static RxState[] values() {
            return (RxState[])$VALUES.clone();
        }

        public static RxState valueOf(String string) {
            return Enum.valueOf(RxState.class, string);
        }

        static {
            RxState rxState;
            STATE_INIT = new RxState();
            STATE_MODE = new RxState();
            STATE_STATUS = new RxState();
            STATE_CMD = new RxState();
            STATE_SIZE_LSB = new RxState();
            STATE_SIZE_MSB = new RxState();
            STATE_DATA = new RxState();
            STATE_CRC_LSB = new RxState();
            STATE_CRC_BYTE2 = new RxState();
            STATE_CRC_BYTE3 = new RxState();
            STATE_CRC_MSB = new RxState();
            RxState rxState2 = rxState;
            STATE_ERROR = new RxState();
            $VALUES = new RxState[]{STATE_INIT, STATE_MODE, STATE_STATUS, STATE_CMD, STATE_SIZE_LSB, STATE_SIZE_MSB, STATE_DATA, STATE_CRC_LSB, STATE_CRC_BYTE2, STATE_CRC_BYTE3, STATE_CRC_MSB, rxState2};
        }
    }
}

