/*
 * Decompiled with CFR 0.152.
 */
package com.bosch.mtprotocol.type.field;

import com.bosch.mtprotocol.type.field.BitField;

public class Field {
    private static final int MAX_FIELD_LENGTH = 32;
    private final int position;
    private final int length;
    private long value = 0L;

    public Field(BitField bitField, int n2) {
        if (n2 <= 32) {
            if (n2 >= 1) {
                int n3;
                this.position = n3 = bitField.nextFieldPosition;
                this.length = n2;
                bitField.nextFieldPosition = n3 + n2;
                bitField.add(this);
                return;
            }
            throw new IllegalArgumentException("Minimum length of field is 1 bit.");
        }
        throw new IllegalArgumentException("Maximum length of field is 32 bits.");
    }

    public int getPosition() {
        return this.position;
    }

    public int getLength() {
        return this.length;
    }

    public byte getByte() {
        return (byte)this.value;
    }

    public void setByte(byte by) {
        this.value = (long)by & 0xFFL;
    }

    public short getShort() {
        return (short)this.value;
    }

    public void setShort(short s2) {
        this.value = (long)s2 & 0xFFFFL;
    }

    public int getValue() {
        return (int)this.value;
    }

    public void setValue(int n2) {
        this.value = (long)n2 & 0xFFFFFFFFL;
    }

    public long getLong() {
        return this.value;
    }

    public void setLong(long l2) {
        this.value = l2;
    }

    public float getFloat() {
        return Float.intBitsToFloat((int)this.value);
    }

    public void setFloat(float f3) {
        this.value = Float.floatToIntBits(f3);
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.value);
    }

    public void setDouble(double d3) {
        this.value = Double.doubleToLongBits(d3);
    }

    public boolean isSet() {
        return this.value != 0L;
    }

    public long getShiftedValue() {
        Field field = this;
        int n2 = field.length;
        long l2 = -1L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
        return (field.value & l2) << this.position;
    }

    public void setShiftedValue(long l2) {
        Field field = this;
        int n2 = field.length;
        long l3 = -1L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
        this.value = l2 >>> field.position & l3;
    }

    public String toString() {
        return "position: " + this.position + ", length: " + this.length + ", data: " + Long.toBinaryString(this.getLong()) + ", shifted data: " + Long.toBinaryString(this.getShiftedValue());
    }
}

