/*
 * Decompiled with CFR 0.152.
 */
package com.huace.gnssserver;

import android.content.Context;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;
import com.huace.gnssserver.app.LogWrapper;

public class WakeLockManager {
    public static final String TAG = "WakeLockManager";
    private static WakeLockManager sInstance;
    private PowerManager.WakeLock mWakeLock = null;
    private boolean mIsAcquired = false;

    private WakeLockManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WakeLockManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<WakeLockManager> clazz = WakeLockManager.class;
        synchronized (WakeLockManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new WakeLockManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void acquire(Context context) {
        if (Build.VERSION.SDK_INT > 22) {
            return;
        }
        if (this.mIsAcquired) {
            return;
        }
        if (this.mWakeLock == null) {
            this.mWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(0x20000001, context.getClass().getCanonicalName());
            this.mWakeLock.acquire();
            LogWrapper.i("WakeLockManagercall acquireWakeLock");
        }
        this.mIsAcquired = true;
    }

    public void release() {
        if (!this.mIsAcquired) {
            return;
        }
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        if (wakeLock != null && wakeLock.isHeld()) {
            Log.i((String)TAG, (String)"call releaseWakeLock");
            this.mWakeLock.release();
            this.mWakeLock = null;
        }
        this.mIsAcquired = false;
    }
}

