/*
 * Decompiled with CFR 0.152.
 */
package com.huace.gnssserver.debug;

import android.support.annotation.NonNull;
import com.huace.gnssserver.debug.DebugUtils;
import com.huace.gnssserver.debug.IDebugDataRecord;
import java.io.FileOutputStream;

public abstract class BaseDebugDataRecord
implements IDebugDataRecord {
    protected FileOutputStream mOutputStream = null;
    private boolean mIsStart = false;

    protected abstract boolean isRecord();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void notifyParameterChanged() {
        try {
            if (this.isRecord()) {
                if (this.isStart()) {
                    return;
                }
                this.start();
                return;
            }
            if (!this.isStart()) {
                return;
            }
            this.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public synchronized void restart() {
        if (!this.isStart()) {
            return;
        }
        this.start();
    }

    protected void start() {
        try {
            BaseDebugDataRecord baseDebugDataRecord = this;
            baseDebugDataRecord.close();
            baseDebugDataRecord.mOutputStream = baseDebugDataRecord.createOutputStream();
            baseDebugDataRecord.mIsStart = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected FileOutputStream createOutputStream() {
        return DebugUtils.createOutputStreamByTimeMillis(this.getSuffix());
    }

    protected boolean isStart() {
        return this.mIsStart;
    }

    @Override
    public synchronized void write(byte[] byArray) {
        block5: {
            block4: {
                if (this.mIsStart) break block4;
                return;
            }
            if (this.mOutputStream == null) break block5;
            try {
                this.mOutputStream.write(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void close() {
        try {
            if (this.mOutputStream != null) {
                this.mOutputStream.close();
                this.mOutputStream = null;
            }
            this.mIsStart = false;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @NonNull
    protected String getSuffix() {
        return "debug.txt";
    }
}

