/*
 * Decompiled with CFR 0.152.
 */
package com.huace.gnssserver.sdk.databack.record;

import com.huace.gnssserver.debug.BaseDebugDataRecord;
import com.huace.gnssserver.debug.DebugUtils;
import com.huace.gnssserver.j.i;
import com.huace.gnssserver.sdk.databack.DataBackSetting;
import com.huace.gnssserver.sdk.databack.record.ObserveDataRecordManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;

public abstract class BaseObserveDataRecorder
extends BaseDebugDataRecord {
    private static final long OBSERVE_FILE_RECORD_TIME_INTERVAL = 3600000L;
    protected boolean mIsReceivedData = false;
    private Date mStartRecordingDate;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkFileTime() {
        block5: {
            if (this.mStartRecordingDate == null || this.mOutputStream == null) break block5;
            if (new Date().getTime() - this.mStartRecordingDate.getTime() <= 3600000L) return;
            if (this.mOutputStream != null) {
                this.mOutputStream.close();
                this.mOutputStream = null;
            }
            this.createOutputStream();
            return;
        }
        try {
            this.createOutputStream();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return;
    }

    private String createNewFilePath() {
        Date date;
        Object object = date;
        this.mStartRecordingDate = new Date();
        String string = DebugUtils.sSimpleDateFormat.format((Date)object);
        object = DataBackSetting.getInstance().getRecordFolder();
        return (String)object + File.separator + string + this.getSuffix();
    }

    @Override
    protected boolean isRecord() {
        return ObserveDataRecordManager.getInstance().isRecord();
    }

    @Override
    protected FileOutputStream createOutputStream() {
        FileOutputStream fileOutputStream;
        i.f(DataBackSetting.getInstance().getRecordFolder());
        if (!this.mIsReceivedData) {
            return null;
        }
        String string = this.createNewFilePath();
        FileOutputStream fileOutputStream2 = fileOutputStream;
        fileOutputStream2(string);
        this.mOutputStream = fileOutputStream2;
        return fileOutputStream;
    }

    protected synchronized void writeData(byte[] byArray) {
        BaseObserveDataRecorder baseObserveDataRecorder = fileOutputStream;
        baseObserveDataRecorder.checkFileTime();
        baseObserveDataRecorder.write(byArray);
        FileOutputStream fileOutputStream = baseObserveDataRecorder.mOutputStream;
        if (fileOutputStream != null) {
            try {
                fileOutputStream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

