/*
 * Decompiled with CFR 0.152.
 */
package com.huace.gnssserver.sdk.databack.upload;

import android.support.annotation.NonNull;
import com.huace.gnssserver.GnssService;
import com.huace.gnssserver.e.v.g0;
import com.huace.gnssserver.e.v.g1;
import com.huace.gnssserver.gnss.data.receiver.DopsInfo;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class DataQualityChecker {
    private final int TIME_CONDITIONS;
    private int mPassedSatelliteCount = 0;
    private int mPassedDopCount = 0;

    public DataQualityChecker() {
        this.TIME_CONDITIONS = 120;
    }

    private void resetValue() {
        DataQualityChecker dataQualityChecker = this;
        dataQualityChecker.mPassedSatelliteCount = 0;
        dataQualityChecker.mPassedDopCount = 0;
    }

    private void register() {
        if (!GnssService.BUS.isRegistered((Object)this)) {
            GnssService.BUS.register((Object)this);
        }
    }

    private void unregister() {
        if (GnssService.BUS.isRegistered((Object)this)) {
            GnssService.BUS.unregister((Object)this);
        }
    }

    private void isPassedSatelliteCount(int n2) {
        if (n2 >= 35) {
            if (++this.mPassedSatelliteCount > 120) {
                this.mPassedSatelliteCount = 240;
            }
        } else {
            this.mPassedSatelliteCount = 0;
        }
    }

    private void isPassedDopCount(@NonNull DopsInfo dopsInfo) {
        if (dopsInfo.getPdop() < 6.0) {
            if (++this.mPassedDopCount > 120) {
                this.mPassedDopCount = 240;
            }
        } else {
            this.mPassedDopCount = 0;
        }
    }

    public void start() {
        DataQualityChecker dataQualityChecker = this;
        dataQualityChecker.resetValue();
        dataQualityChecker.register();
    }

    public void stop() {
        DataQualityChecker dataQualityChecker = this;
        dataQualityChecker.unregister();
        dataQualityChecker.resetValue();
    }

    public boolean isPassed() {
        return this.mPassedSatelliteCount > 120 && this.mPassedDopCount > 120;
    }

    @Subscribe(threadMode=ThreadMode.BACKGROUND)
    public void onEventBackgroundThread(g0 g02) {
        try {
            this.isPassedDopCount(g02.b());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Subscribe(threadMode=ThreadMode.BACKGROUND)
    public void onEventBackgroundThread(g1 g12) {
        try {
            this.isPassedSatelliteCount(g12.b().getSatNum());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

