/*
 * Decompiled with CFR 0.152.
 */
package com.pop.android.common.util;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.pop.android.common.util.Ulog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class PublicLib {
    public static final String[] WIFI_REQUIRED_PERMISSIONS = new String[]{"android.permission.ACCESS_WIFI_STATE", "android.permission.ACCESS_NETWORK_STATE", "android.permission.CHANGE_WIFI_STATE"};

    public static boolean allPermissionsGranted(Context context, String[] stringArray) {
        int n2 = stringArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            if (PublicLib.permissionGranted(context, stringArray[i3])) continue;
            return false;
        }
        return true;
    }

    public static boolean permissionGranted(Context context, String string) {
        return context.checkCallingOrSelfPermission(string) == 0;
    }

    public static String getMacAddress(String stringArray) {
        StringBuilder stringBuilder;
        stringArray = stringArray.split(":");
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("wifi");
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            stringBuilder2.append(Integer.parseInt(stringArray[i3], 16));
        }
        return stringBuilder2.toString();
    }

    public static String getDeviceId(Context object) {
        if ((object = ((TelephonyManager)object.getSystemService("phone")).getDeviceId()) == null) {
            object = "";
        }
        return object;
    }

    public static String getAppKey(Context object) {
        block3: {
            object = object.getPackageManager().getPackageInfo((String)object.getPackageName(), (int)16512).applicationInfo.metaData.get("com.pop.api.appKey");
            if (object == null) break block3;
            try {
                return object.toString();
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
        }
        return "";
    }

    public static int getVersionCode(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new Error("Get versionCode error : " + nameNotFoundException.getMessage());
        }
    }

    public static String getVersionName(Context context) {
        String string = "";
        try {
            string = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "1.0.0";
        }
        return string;
    }

    public static String getAppPackageName(Context context) {
        String string = "";
        try {
            string = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).packageName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "com.qx.wz.rtcm";
        }
        return string;
    }

    public static String md5(String object) {
        StringBuilder stringBuilder;
        try {
            object = MessageDigest.getInstance("MD5").digest(((String)object).getBytes());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("No MD5 support in this VM.");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
            String string = Integer.toHexString((int)object[i3]);
            if (string.length() == 1) {
                String string2 = string;
                stringBuilder2.append('0');
                stringBuilder2.append(string2.charAt(string2.length() - 1));
                continue;
            }
            String string3 = string;
            stringBuilder2.append(string3.substring(string3.length() - 2));
        }
        return stringBuilder2.toString();
    }

    public static String generateMapRequestUrl() {
        return "http://203.130.47.12/ws/mapapi/indoor_maps?output=json&poiid=" + "B023B173VP" + "&sign=" + PublicLib.md5("openapi" + "B023B173VP" + "@528c378114c44a549debb59334ddd6b1") + "&channel=openapi&allfloors=true&servicetype=autonavi";
    }

    public static Map<String, Integer> getSourceIdToLayer() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("GD0000320100300001", -3);
        hashMap.put("GD0000320100200001", -2);
        hashMap.put("GD0000320100100001", -1);
        hashMap.put("GD0000320110100002", 1);
        hashMap.put("GD0000320110200003", 2);
        hashMap.put("GD0000320110300004", 3);
        hashMap.put("GD0000320110400005", 4);
        hashMap.put("GD0000320110500006", 5);
        hashMap.put("GD0000320110600007", 6);
        hashMap.put("GD0000320110700008", 7);
        return hashMap;
    }

    public static void showRandomInteger(int n2, int n3, Random random) {
        if (n2 <= n3) {
            random.nextDouble();
            return;
        }
        throw new IllegalArgumentException("Start cannot exceed End.");
    }

    public static double showRandomNumber(double d3, double d4, Random random) {
        if (!(d3 > d4)) {
            return (d4 - d3) * random.nextDouble() + d3;
        }
        throw new IllegalArgumentException("Start cannot exceed End.");
    }

    public static boolean isBtAvailable() {
        boolean bl = false;
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter != null) {
            bl = bluetoothAdapter.isEnabled();
        }
        return bl;
    }

    public static boolean setBluetooth(boolean bl) {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        boolean bl2 = bluetoothAdapter.isEnabled();
        if (bl && !bl2) {
            return bluetoothAdapter.enable();
        }
        if (!bl && bl2) {
            return bluetoothAdapter.disable();
        }
        return true;
    }

    public static boolean isNetworkAvailable(Context context) {
        boolean bl;
        block4: {
            bl = false;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager.getActiveNetworkInfo() == null) break block4;
            try {
                bl = connectivityManager.getActiveNetworkInfo().isAvailable();
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public static void setNetwork(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (wifiManager != null && !wifiManager.isWifiEnabled()) {
            wifiManager.setWifiEnabled(true);
        }
        context = (ConnectivityManager)context.getSystemService("connectivity");
        Class<ConnectivityManager> clazz = ConnectivityManager.class;
        Class[] classArray = new Class[1];
        classArray[0] = Boolean.TYPE;
        Method method = clazz.getDeclaredMethod("setMobileDataEnabled", classArray);
        Context context2 = context;
        method.setAccessible(true);
        Object[] objectArray = new Object[1];
        try {
            objectArray[0] = Boolean.TRUE;
            method.invoke((Object)context2, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            Ulog.w("set Mobile network failed", " " + illegalAccessException.getMessage());
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Ulog.w("set Mobile network failed", " " + invocationTargetException.getMessage());
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Ulog.w("set Mobile network failed", " " + noSuchMethodException.getMessage());
            return;
        }
        return;
    }

    public static boolean isLocationMock(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"mock_location").equals("1");
    }

    public static List<String> getBtBox(Set<BluetoothDevice> collection) {
        ArrayList arrayList;
        Set<BluetoothDevice> set = collection;
        collection = arrayList;
        arrayList = new ArrayList();
        for (BluetoothDevice bluetoothDevice : set) {
            if (bluetoothDevice == null || TextUtils.isEmpty((CharSequence)bluetoothDevice.getName()) || !bluetoothDevice.getName().contains("QX BeiDou Box")) continue;
            collection.add(bluetoothDevice.getName() + "(" + bluetoothDevice.getAddress() + ")");
        }
        return collection;
    }

    public static String getIMEI(Context context) {
        block4: {
            try {
                context = (TelephonyManager)context.getSystemService("phone");
            }
            catch (Exception exception) {
                Ulog.w("get phone state:", "Fail to get IMEI:" + exception.getMessage());
                return null;
            }
            if (context.getDeviceId() != null) break block4;
            return "";
        }
        return context.getDeviceId();
    }

    public static String getPhoneNum(Context context) {
        block4: {
            try {
                context = (TelephonyManager)context.getSystemService("phone");
            }
            catch (Exception exception) {
                Ulog.w("get phone state:", "Fail to get phone number:" + exception.getMessage());
                return null;
            }
            if (context.getLine1Number() != null) break block4;
            return "";
        }
        return context.getLine1Number();
    }

    public static String getThrowableMsg(Throwable object) {
        if (object != null) {
            PrintWriter printWriter;
            StringWriter stringWriter;
            Throwable throwable = object;
            object = stringWriter;
            stringWriter = new StringWriter();
            PrintWriter printWriter2 = printWriter;
            throwable.printStackTrace(new PrintWriter((Writer)object));
            String string = object.toString();
            printWriter2.close();
            return string;
        }
        throw new NullPointerException("e is null");
    }
}

