/*
 * Decompiled with CFR 0.152.
 */
package com.pop.android.common.util.nmea.parser;

import com.pop.android.common.beans.GpsFixQuality;
import com.pop.android.common.util.nmea.parser.ParseException;
import com.pop.android.common.util.nmea.parser.PositionParser;
import com.pop.android.common.util.nmea.parser.SentenceParser;
import com.pop.android.common.util.nmea.sentence.SentenceId;
import com.pop.android.common.util.nmea.sentence.TalkerId;
import com.pop.android.common.util.nmea.util.Position;
import com.pop.android.common.util.nmea.util.Time;
import com.pop.android.common.util.nmea.util.Units;

public class GGAParser
extends PositionParser {
    private static final int UTC_TIME = 0;
    private static final int LATITUDE = 1;
    private static final int LAT_HEMISPHERE = 2;
    private static final int LONGITUDE = 3;
    private static final int LON_HEMISPHERE = 4;
    private static final int FIX_QUALITY = 5;
    private static final int SATELLITES_IN_USE = 6;
    private static final int HORIZONTAL_DILUTION = 7;
    private static final int ALTITUDE = 8;
    private static final int ALTITUDE_UNITS = 9;
    private static final int GEOIDAL_HEIGHT = 10;
    private static final int HEIGHT_UNITS = 11;
    private static final int DGPS_AGE = 12;
    private static final int DGPS_STATION_ID = 13;
    char ALT_UNIT_METERS = (char)77;
    char ALT_UNIT_FEET = (char)102;

    public GGAParser(String string) {
        super(string, SentenceId.GGA);
    }

    public GGAParser(TalkerId talkerId) {
        super(talkerId, SentenceId.GGA, 14);
    }

    public double getAltitude() {
        return this.getDoubleValue(8);
    }

    public Units getAltitudeUnits() {
        char c3 = objectArray2.getCharValue(9);
        if (c3 != objectArray2.ALT_UNIT_METERS && c3 != objectArray2.ALT_UNIT_FEET) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Character.valueOf(c3);
            throw new ParseException(String.format("Invalid altitude unit indicator: %s", objectArray2));
        }
        return Units.valueOf(c3);
    }

    public double getDgpsAge() {
        return this.getDoubleValue(12);
    }

    public String getDgpsStationId() {
        return this.getStringValue(13);
    }

    public GpsFixQuality getFixQuality() {
        return GpsFixQuality.valueOf(this.getIntValue(5));
    }

    public double getGeoidalHeight() {
        return this.getDoubleValue(10);
    }

    public Units getGeoidalHeightUnits() {
        return Units.valueOf(this.getCharValue(11));
    }

    public double getHorizontalDOP() {
        return this.getDoubleValue(7);
    }

    public Position getPosition() {
        GGAParser gGAParser = this;
        Position position = gGAParser.parsePosition(1, 2, 3, 4);
        if (gGAParser.hasValue(8) && this.hasValue(9)) {
            GGAParser gGAParser2 = this;
            double d3 = gGAParser2.getAltitude();
            if (gGAParser2.getAltitudeUnits().equals((Object)Units.FEET)) {
                d3 /= 0.3048;
            }
            position.setAltitude(d3);
        }
        return position;
    }

    public int getSatelliteCount() {
        return this.getIntValue(6);
    }

    public Time getTime() {
        String string = ((SentenceParser)((Object)string)).getStringValue(0);
        return new Time(string);
    }

    public void setAltitude(double d3) {
        this.setDoubleValue(8, d3, 1, 1);
    }

    public void setAltitudeUnits(Units units) {
        this.setCharValue(9, units.toChar());
    }

    public void setDgpsAge(double d3) {
        this.setDoubleValue(12, d3, 1, 1);
    }

    public void setDgpsStationId(String string) {
        this.setStringValue(13, string);
    }

    public void setFixQuality(GpsFixQuality gpsFixQuality) {
        this.setIntValue(5, gpsFixQuality.toInt());
    }

    public void setGeoidalHeight(double d3) {
        this.setDoubleValue(10, d3, 1, 1);
    }

    public void setGeoidalHeightUnits(Units units) {
        this.setCharValue(11, units.toChar());
    }

    public void setHorizontalDOP(double d3) {
        this.setDoubleValue(7, d3, 1, 1);
    }

    public void setPosition(Position position) {
        GGAParser gGAParser = this;
        this.setPositionValues(position, 1, 2, 3, 4);
        gGAParser.setAltitude(position.getAltitude());
        gGAParser.setAltitudeUnits(Units.METER);
    }

    public void setTime(Time time) {
        this.setStringValue(0, time.toString());
    }
}

