/*
 * Decompiled with CFR 0.152.
 */
package com.pop.android.common.util.nmea.parser;

import com.pop.android.common.util.nmea.parser.ParseException;
import com.pop.android.common.util.nmea.sentence.Checksum;
import com.pop.android.common.util.nmea.sentence.Sentence;
import com.pop.android.common.util.nmea.sentence.SentenceId;
import com.pop.android.common.util.nmea.sentence.SentenceValidator;
import com.pop.android.common.util.nmea.sentence.TalkerId;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;

public class SentenceParser
implements Sentence {
    private final String TAG;
    private char beginChar;
    private TalkerId talkerId;
    private final String sentenceId;
    private List<String> fields;

    /*
     * WARNING - void declaration
     */
    public SentenceParser(String object) {
        Object object2;
        object2.TAG = "SentenceParser";
        if (SentenceValidator.isValid((String)object)) {
            void var1_4;
            Object object3 = object;
            object2.beginChar = ((String)object).charAt(0);
            object2.talkerId = TalkerId.parse((String)object);
            object2.sentenceId = SentenceId.parseStr((String)object);
            String string = ((String)object3).substring(((String)object3).indexOf(44) + 1);
            if (string.contains("*")) {
                String string2 = string;
                String string3 = string2.substring(0, string2.indexOf(42));
            }
            String[] stringArray = var1_4.split(",", -1);
            object2.fields = new ArrayList<String>(stringArray.length);
            for (String string4 : stringArray) {
                object2.fields.add(string4);
            }
            return;
        }
        Object[] objectArray = new Object[1];
        object2 = objectArray;
        objectArray[0] = object;
        object2 = String.format("Invalid data [%s]", object2);
        throw new IllegalArgumentException((String)object2);
    }

    protected SentenceParser(char c3, TalkerId talkerId, String string, int n2) {
        this.TAG = "SentenceParser";
        if (n2 > 0) {
            if (talkerId != null) {
                if (string != null && !"".equals(string)) {
                    ArrayList<String> arrayList;
                    SentenceParser sentenceParser = this;
                    sentenceParser.beginChar = c3;
                    sentenceParser.talkerId = talkerId;
                    sentenceParser.sentenceId = string;
                    ArrayList<String> arrayList2 = arrayList;
                    arrayList = new ArrayList<String>(n2);
                    sentenceParser.fields = arrayList2;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        this.fields.add("");
                    }
                    return;
                }
                throw new IllegalArgumentException("Sentence ID must be specified");
            }
            throw new IllegalArgumentException("Talker ID must be specified");
        }
        throw new IllegalArgumentException("Minimum number of fields is 1");
    }

    protected SentenceParser(String objectArray, String string) {
        ((SentenceParser)object)((String)objectArray);
        if (string != null && !"".equals(string)) {
            if (((String)(object = ((SentenceParser)object).getSentenceId())).equals(string)) {
                return;
            }
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = string;
            objectArray2[1] = object;
            Object object = String.format("Sentence id mismatch; expected [%s], found [%s].", objectArray);
            throw new IllegalArgumentException((String)object);
        }
        throw new IllegalArgumentException("Sentence type must be specified.");
    }

    protected SentenceParser(TalkerId talkerId, String string, int n2) {
        this('$', talkerId, string, n2);
    }

    SentenceParser(String string, SentenceId sentenceId) {
        this(string, sentenceId.toString());
    }

    SentenceParser(TalkerId talkerId, SentenceId sentenceId, int n2) {
        this(talkerId, sentenceId.toString(), n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SentenceParser) {
            return ((SentenceParser)object).toString().equals(this.toString());
        }
        return false;
    }

    @Override
    public final char getBeginChar() {
        return this.beginChar;
    }

    @Override
    public final int getFieldCount() {
        List<String> list = ((SentenceParser)((Object)list)).fields;
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    public final String getSentenceId() {
        return this.sentenceId;
    }

    @Override
    public final TalkerId getTalkerId() {
        return this.talkerId;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean isProprietary() {
        return TalkerId.P.equals((Object)this.getTalkerId());
    }

    @Override
    public boolean isValid() {
        return SentenceValidator.isValid(this.toString());
    }

    @Override
    public final void reset() {
        for (int i3 = 0; i3 < this.fields.size(); ++i3) {
            this.fields.set(i3, "");
        }
    }

    @Override
    public void setBeginChar(char c3) {
        if (c3 != '$' && c3 != '!') {
            throw new IllegalArgumentException("Invalid begin char; expected '$' or '!'");
        }
        this.beginChar = c3;
    }

    @Override
    public final void setTalkerId(TalkerId talkerId) {
        this.talkerId = talkerId;
    }

    @Override
    public final String toSentence() {
        Object[] objectArray = ((SentenceParser)((Object)string)).toString();
        if (SentenceValidator.isValid((String)objectArray)) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = ((SentenceParser)((Object)string)).toString();
        String string = String.format("Validation failed [%s]", objectArray);
        throw new IllegalStateException(string);
    }

    @Override
    public final String toSentence(int n2) {
        if (((String)(object = ((SentenceParser)object).toSentence())).length() <= n2) {
            return object;
        }
        Object object = "Sentence max length exceeded " + n2;
        throw new IllegalStateException((String)object);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2(82);
        stringBuilder2.append(((SentenceParser)this).beginChar);
        stringBuilder2.append(((SentenceParser)this).talkerId.toString());
        stringBuilder.append(((SentenceParser)this).sentenceId);
        for (String string : ((SentenceParser)this).fields) {
            stringBuilder2.append(',');
            if (string == null) {
                string = "";
            }
            stringBuilder2.append(string);
        }
        return Checksum.add(stringBuilder2.toString());
    }

    protected final char getCharValue(int n2) {
        if (((String)(object = ((SentenceParser)object).getStringValue(n2))).length() <= 1) {
            return ((String)object).charAt(0);
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        Object object = String.format("Expected char, found String [%s]", objectArray2);
        throw new ParseException((String)object);
    }

    protected final double getDoubleValue(int n2) {
        try {
            return Double.parseDouble(this.getStringValue(n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Field does not contain double value", numberFormatException);
        }
    }

    protected final int getIntValue(int n2) {
        try {
            return Integer.parseInt(this.getStringValue(n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Field does not contain integer value", numberFormatException);
        }
    }

    protected final String getStringValue(int n2) {
        String string = ((SentenceParser)((Object)string)).fields.get(n2);
        if (string != null && !"".equals(string)) {
            return string;
        }
        throw new ParseException("Data not available");
    }

    protected final boolean hasValue(int n2) {
        boolean bl = true;
        try {
            this.getStringValue(n2);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    protected final void setCharValue(int n2, char c3) {
        this.setStringValue(n2, String.valueOf(c3));
    }

    protected final void setDegreesValue(int n2, double d3) {
        if (!(d3 < 0.0) && !(d3 > 360.0)) {
            this.setDoubleValue(n2, d3, 3, 1);
            return;
        }
        throw new IllegalArgumentException("Value out of bounds [0..360]");
    }

    protected final void setDoubleValue(int n2, double d3) {
        this.setStringValue(n2, String.valueOf(d3));
    }

    protected final void setDoubleValue(int n2, double d3, int n3, int n4) {
        DecimalFormat decimalFormat;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (int i3 = 0; i3 < n3; ++i3) {
            stringBuilder2.append('0');
        }
        if (n4 > 0) {
            stringBuilder2.append('.');
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuilder2.append('0');
            }
        }
        if (stringBuilder2.length() == 0) {
            stringBuilder2.append('0');
        }
        SentenceParser sentenceParser = this;
        Object object = this = decimalFormat;
        ((DecimalFormat)object)(stringBuilder2.toString());
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        ((DecimalFormat)object).setDecimalFormatSymbols(decimalFormatSymbols);
        sentenceParser.setStringValue(n2, decimalFormat.format(d3));
    }

    protected final void setFieldCount(int n2) {
        if (n2 > 0) {
            if (n2 < this.fields.size()) {
                this.fields = this.fields.subList(0, n2);
                return;
            }
            if (n2 > this.fields.size()) {
                for (int i3 = this.fields.size(); i3 < n2; ++i3) {
                    this.fields.add("");
                }
            }
            return;
        }
        throw new IllegalArgumentException("Number of fields must be greater than zero.");
    }

    protected final void setIntValue(int n2, int n3) {
        this.setStringValue(n2, String.valueOf(n3));
    }

    protected final void setIntValue(int n2, int n3, int n4) {
        String string = "%d";
        if (n4 > 0) {
            string = "%0" + n4 + "d";
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = n3;
        objectArray.setStringValue(n2, String.format(string, objectArray3));
    }

    protected final void setStringValue(int n2, String string) {
        List<String> list = ((SentenceParser)((Object)list)).fields;
        if (string == null) {
            string = "";
        }
        list.set(n2, string);
    }

    protected final void setStringValues(int n2, String[] stringArray) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        for (int i3 = 0; i3 < this.getFieldCount() && i3 < n2; ++i3) {
            arrayList2.add(this.fields.get(i3));
        }
        for (String string : stringArray) {
            if (string == null) {
                string = "";
            }
            arrayList2.add(string);
        }
        this.fields.clear();
        this.fields = arrayList2;
    }
}

