/*
 * Decompiled with CFR 0.152.
 */
package com.pop.android.common.util.nmea.util;

import com.pop.android.common.util.nmea.util.CompassPoint;
import com.pop.android.common.util.nmea.util.Datum;

public class Position {
    private double latitude;
    private double longitude;
    private double altitude = 0.0;
    private Datum datum = Datum.WGS84;

    public Position(double d3, double d4) {
        this.setLatitude(d3);
        this.setLongitude(d4);
    }

    public Position(double d3, double d4, double d5) {
        this(d3, d4);
        this.altitude = d5;
    }

    public Position(double d3, double d4, Datum datum) {
        this(d3, d4);
        this.datum = datum;
    }

    public Position(double d3, double d4, double d5, Datum datum) {
        this(d3, d4, d5);
        this.datum = datum;
    }

    private double haversine(double d3, double d4, double d5, double d6) {
        d4 = Math.toRadians(d6 - d4);
        d6 = Math.toRadians(d5 - d3) / 2.0;
        double d7 = d4 / 2.0;
        d7 = Math.sin(d6) * Math.sin(d6) + Math.cos(Math.toRadians(d3)) * Math.cos(Math.toRadians(d5)) * Math.sin(d7) * Math.sin(d7);
        return Math.atan2(Math.sqrt(d7), Math.sqrt(1.0 - d7)) * 2.0 * 6366.70702 * 1000.0;
    }

    public double distanceTo(Position position) {
        Position position2 = position;
        Position position3 = this;
        double d3 = position3.getLatitude();
        double d4 = position3.getLongitude();
        double d5 = position2.getLatitude();
        double d6 = position2.getLongitude();
        return this.haversine(d3, d4, d5, d6);
    }

    public double getAltitude() {
        return this.altitude;
    }

    public Datum getDatum() {
        return this.datum;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public CompassPoint getLatitudeHemisphere() {
        if (this.isLatitudeNorth()) {
            return CompassPoint.NORTH;
        }
        return CompassPoint.SOUTH;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public CompassPoint getLongitudeHemisphere() {
        if (this.isLongitudeEast()) {
            return CompassPoint.EAST;
        }
        return CompassPoint.WEST;
    }

    public boolean isLatitudeNorth() {
        return this.getLatitude() >= 0.0;
    }

    public boolean isLongitudeEast() {
        return this.getLongitude() >= 0.0;
    }

    public void setAltitude(double d3) {
        this.altitude = d3;
    }

    public void setLatitude(double d3) {
        if (!(d3 < -90.0) && !(d3 > 90.0)) {
            this.latitude = d3;
            return;
        }
        throw new IllegalArgumentException("Latitude out of bounds -90..90 degrees");
    }

    public void setLongitude(double d3) {
        if (!(d3 < -180.0) && !(d3 > 180.0)) {
            this.longitude = d3;
            return;
        }
        throw new IllegalArgumentException("Longitude out of bounds -180..180 degrees");
    }

    public String toString() {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = objectArray2 = objectArray;
        Object[] objectArray4 = objectArray2;
        Object[] objectArray5 = objectArray2;
        Object[] objectArray6 = objectArray2;
        objectArray5();
        objectArray6.append("[");
        Object[] objectArray7 = new Object[1];
        objectArray2 = objectArray7;
        objectArray7[0] = Math.abs(this.getLatitude());
        objectArray5.append(String.format("%02.04f", objectArray2));
        objectArray6.append(" ");
        objectArray3.append(this.getLatitudeHemisphere().toChar());
        objectArray4.append(", ");
        Object[] objectArray8 = new Object[1];
        objectArray2 = objectArray8;
        objectArray8[0] = Math.abs(this.getLongitude());
        objectArray3.append(String.format("%03.04f", objectArray2));
        objectArray4.append(" ");
        objectArray2.append(this.getLongitudeHemisphere().toChar());
        objectArray2.append(", ");
        objectArray.append(this.getAltitude());
        objectArray.append(" m]");
        return objectArray.toString();
    }
}

