/*
 * Decompiled with CFR 0.152.
 */
package com.pop.android.net;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import com.pop.android.a.a;
import com.pop.android.common.util.GenericsUtil;
import com.pop.android.common.util.Ulog;
import com.pop.android.net.FeedbackCallback;
import com.pop.android.net.POPClientPolicy;
import com.pop.android.net.POPMessage;
import com.pop.android.net.annotation.API;
import com.pop.android.net.annotation.APIParameter;
import com.pop.android.net.annotation.Cache;
import com.pop.android.net.connector.HttpConnectRequestCallable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class POPClient {
    public static final String LOG_TAG = "POPClient";
    public static POPClient INSTANCE;
    public POPClientPolicy policy;
    public Context context;
    private String packageName;
    private String versionName;
    private String ua;

    public static synchronized void init(Context context, POPClientPolicy pOPClientPolicy) {
        if (INSTANCE == null) {
            INSTANCE = new POPClient(context, pOPClientPolicy);
        }
    }

    public POPClient(Context context, POPClientPolicy pOPClientPolicy) {
        this.context = context.getApplicationContext();
        this.policy = pOPClientPolicy.clone();
        this.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void init() {
        Object object;
        try {
            POPClient pOPClient = this;
            a.a("POPLocation");
            a.a(pOPClient.context);
            object = pOPClient.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 16512);
            pOPClient.packageName = ((PackageInfo)object).packageName;
            pOPClient.versionName = ((PackageInfo)object).versionName;
            pOPClient.ua = "POP_Android_SDK 1.0/" + this.packageName + '_' + this.versionName;
            if (pOPClient.policy.signingKey == null) {
                this.policy.signingKey = ((PackageInfo)object).packageName.getBytes("UTF-8");
            }
            if (this.policy.appKey != null) return;
            object = ((PackageInfo)object).applicationInfo;
        }
        catch (Exception exception) {
            Ulog.w(LOG_TAG, "POPClient.init Exception: " + exception.getMessage());
            return;
        }
        if (((ApplicationInfo)object).metaData == null) return;
        object = ((ApplicationInfo)object).metaData.get("com.pop.api.appKey");
        if (object == null) return;
        this.policy.appKey = object.toString();
    }

    public <T> T getProxy(Class<T> clazz) {
        Ulog.i(LOG_TAG, "Get Proxy Object for " + clazz.getName());
        try {
            return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new APIProxy(this, clazz));
        }
        catch (Exception exception) {
            Ulog.w(LOG_TAG, "POPClient.getProxy RuntimeException: " + exception.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Ulog.w(LOG_TAG, "POPClient.getProxy IllegalArgumentException: " + illegalArgumentException.getMessage());
        }
        return null;
    }

    public <T> Future<T> asyncSend(POPMessage pOPMessage, Class<T> clazz, FeedbackCallback<T> feedbackCallback) {
        HttpConnectRequestCallable<T> httpConnectRequestCallable;
        FutureTask<T> futureTask;
        if (pOPMessage.policy == null) {
            pOPMessage.policy = ((POPClient)((Object)string)).policy;
        }
        FutureTask<T> futureTask2 = futureTask;
        HttpConnectRequestCallable<T> httpConnectRequestCallable2 = httpConnectRequestCallable;
        String string = ((POPClient)((Object)string)).ua;
        httpConnectRequestCallable = new HttpConnectRequestCallable<T>(pOPMessage, clazz, feedbackCallback, string);
        futureTask = new FutureTask<T>(httpConnectRequestCallable2);
        new Thread(futureTask2).start();
        return futureTask;
    }

    public <T> T send(POPMessage pOPMessage, Class<T> object) {
        FeedbackCallback feedbackCallback;
        Response response;
        CountDownLatch countDownLatch;
        final CountDownLatch countDownLatch2 = countDownLatch;
        countDownLatch = new CountDownLatch(1);
        final Response response2 = response;
        response = new Response();
        FeedbackCallback feedbackCallback2 = feedbackCallback;
        feedbackCallback = new FeedbackCallback<T>(){

            @Override
            public void failed(Throwable throwable) {
                response2.error = throwable;
                countDownLatch2.countDown();
            }

            @Override
            public void cancelled() {
                countDownLatch2.countDown();
            }

            @Override
            public void feedbackHeader(String string, String string2) {
            }

            @Override
            public void feedbackBody(T t2) {
                response2.result = t2;
                countDownLatch2.countDown();
            }
        };
        long l2 = System.currentTimeMillis();
        ((POPClient)((Object)string)).asyncSend(pOPMessage, (Class<T>)object, feedbackCallback2);
        object = pOPMessage.policy;
        long l3 = object == null ? (long)((POPClient)((Object)string)).policy.timeout : (long)((POPClientPolicy)object).timeout;
        if (countDownLatch2.await(l3, TimeUnit.MILLISECONDS)) {
            if (response2.error == null) {
                return (T)response2.result;
            }
            String string = "cost" + (System.currentTimeMillis() - l2) + "ms";
            throw new ExecutionException(string, response2.error);
        }
        Ulog.w(LOG_TAG, "Synchronous API [" + pOPMessage.name + "] send request timeout.");
        throw new TimeoutException("send msg timeout with " + (System.currentTimeMillis() - l2) + "ms");
    }

    static class APIProxy
    implements InvocationHandler {
        private final POPClient client;
        private final Map<Method, APIMethodDefination> methodDefinations;

        public APIProxy(POPClient pOPClient, Class<?> clazz) {
            this.client = pOPClient;
            this.methodDefinations = AnnotationAPIParser.parseDefinations(pOPClient.policy, clazz);
        }

        private Object doInvoke(APIMethodDefination object, Object object2, Method method, Object[] objectArray) {
            Object object3;
            int n2;
            POPMessage pOPMessage;
            object2 = pOPMessage;
            Object object4 = ((APIProxy)((Object)clazz)).client;
            pOPMessage = new POPMessage((POPClient)object4, ((APIMethodDefination)object).api);
            object4 = ((APIMethodDefination)object).paramNames;
            if (object4 != null) {
                for (Map.Entry entry : object4.entrySet()) {
                    String string = (String)entry.getKey();
                    ((POPMessage)object2).bodyParam(string, objectArray[(Integer)entry.getValue()]);
                }
            }
            if (objectArray != null && objectArray.length > 0) {
                int n3 = objectArray.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    Object object5 = objectArray[i3];
                    if (!(object5 instanceof POPClientPolicy)) continue;
                    ((POPMessage)object2).policy((POPClientPolicy)object5);
                    break;
                }
            }
            if ((n2 = ((APIMethodDefination)object).cacheType) > 0) {
                ((POPMessage)object2).cacheType = n2;
                ((POPMessage)object2).cacheKey = ((APIProxy)((Object)clazz)).cacheKey((APIMethodDefination)object, objectArray);
            }
            if ((object3 = ((APIMethodDefination)object).protocol) == null) {
                object3 = ((POPMessage)object2).policy;
                object3 = object3 != null ? ((POPClientPolicy)object3).protocol : ((APIProxy)((Object)clazz)).client.policy.protocol;
            }
            ((POPMessage)object2).protocol = object3;
            Class<?> clazz = method.getReturnType();
            if (((APIMethodDefination)object).ansyInvoke) {
                Ulog.w(POPClient.LOG_TAG, "Asynchronous invoke " + method.getName());
                object = (FeedbackCallback)objectArray[objectArray.length - 1];
                if (Future.class.isAssignableFrom(clazz)) {
                    return ((POPMessage)object2).asyncSend(GenericsUtil.getMethodGenericReturnType(method, Future.class, 0), object);
                }
                if (Void.TYPE.equals(clazz)) {
                    ((POPMessage)object2).asyncSend(clazz, object);
                    return null;
                }
                ((POPMessage)object2).asyncSend(clazz, object);
                return null;
            }
            Ulog.w(POPClient.LOG_TAG, "Synchronous invoke " + method.getName());
            return ((POPMessage)object2).send(clazz);
        }

        private String cacheKey(APIMethodDefination object, Object[] objectArray) {
            StringBuilder stringBuilder = new StringBuilder("api:").append(((APIMethodDefination)object).api);
            object = ((APIMethodDefination)object).cacheKeyParams;
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    int n2 = (Integer)object.next();
                    stringBuilder.append('|').append(objectArray[n2]);
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) {
            Ulog.w(POPClient.LOG_TAG, "Start invoke " + method.getName());
            APIMethodDefination aPIMethodDefination = this.methodDefinations.get(method);
            if (aPIMethodDefination != null) {
                return this.doInvoke(aPIMethodDefination, object, method, objectArray);
            }
            Ulog.w(POPClient.LOG_TAG, method.getName() + " can not be proxy");
            throw new InternalError(method.getName() + " can not be proxy");
        }
    }

    static final class AnnotationAPIParser {
        private AnnotationAPIParser() {
        }

        public static Map<Method, APIMethodDefination> parseDefinations(POPClientPolicy object, Class<?> serializable) {
            LinkedHashMap linkedHashMap;
            Class<?> clazz = serializable;
            object = clazz.getAnnotation(API.class);
            serializable = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
            for (Method method : clazz.getDeclaredMethods()) {
                APIMethodDefination aPIMethodDefination;
                Object object2;
                if (!Modifier.isPublic(method.getModifiers())) continue;
                Annotation[][] annotationArray = null;
                Class<?>[] classArray = null;
                if (object != null) {
                    Object object3 = object;
                    annotationArray = object3.value();
                    if (object3.protocol() != null && object.protocol().length() > 0) {
                        classArray = object.protocol();
                    }
                }
                if ((object2 = method.getAnnotation(API.class)) == null) continue;
                if (object2.value() != null && object2.value().length() > 0) {
                    annotationArray = object2.value();
                }
                if (object2.protocol() != null && object2.protocol().length() > 0) {
                    classArray = object2.protocol();
                }
                Method method2 = method;
                object2 = aPIMethodDefination;
                ((APIMethodDefination)object2)();
                ((APIMethodDefination)object2).api = annotationArray;
                ((APIMethodDefination)object2).protocol = classArray;
                aPIMethodDefination.method = method;
                annotationArray = method2.getParameterAnnotations();
                classArray = method2.getParameterTypes();
                int n2 = classArray.length;
                Cache cache = method2.getAnnotation(Cache.class);
                if (cache != null) {
                    Object object4 = object2;
                    ((APIMethodDefination)object4).cacheType = cache.value();
                    ((APIMethodDefination)object4).cacheKeyParams = new ArrayList<Integer>(n2);
                }
                if (annotationArray != null && classArray != null && classArray.length > 0) {
                    LinkedHashMap<String, Integer> linkedHashMap2;
                    if (annotationArray.length != n2) {
                        Ulog.w(POPClient.LOG_TAG, method.getName() + " paramAnnotations.length and args.length is not equale");
                        continue;
                    }
                    LinkedHashMap<String, Integer> linkedHashMap3 = linkedHashMap2;
                    linkedHashMap2 = new LinkedHashMap<String, Integer>();
                    ((APIMethodDefination)object2).paramNames = linkedHashMap3;
                    block1: for (int i3 = 0; i3 < n2; ++i3) {
                        Object object5 = annotationArray[i3];
                        int n3 = ((Annotation[])object5).length;
                        for (int i4 = 0; i4 < n3; ++i4) {
                            Annotation annotation = object5[i4];
                            if (!APIParameter.class.equals(annotation.annotationType())) continue;
                            object5 = (APIParameter)annotation;
                            String string = object5.value();
                            ((APIMethodDefination)object2).paramNames.put(string, i3);
                            if (cache == null || !object5.cacheKey()) continue block1;
                            ((APIMethodDefination)object2).cacheKeyParams.add(i3);
                            continue block1;
                        }
                    }
                    if (FeedbackCallback.class.isAssignableFrom(classArray[n2 - 1])) {
                        ((APIMethodDefination)object2).ansyInvoke = true;
                    }
                }
                serializable.put(method, object2);
            }
            return serializable;
        }
    }

    static class APIMethodDefination {
        Method method;
        String api;
        String protocol;
        int cacheType;
        List<Integer> cacheKeyParams;
        POPClientPolicy policy;
        Map<String, Integer> paramNames;
        boolean ansyInvoke = false;

        APIMethodDefination() {
        }

        public String toString() {
            if (" api [ name=" + this.api + "; method name=" + this.method == null) {
                return null;
            }
            return this.method.getName() + " ]";
        }
    }

    public static class Response {
        Object result;
        Throwable error;
    }
}

