/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson;

import com.qx.wz.external.fastjson.JSONException;
import com.qx.wz.external.fastjson.JSONStreamContext;
import com.qx.wz.external.fastjson.TypeReference;
import com.qx.wz.external.fastjson.parser.DefaultJSONParser;
import com.qx.wz.external.fastjson.parser.Feature;
import com.qx.wz.external.fastjson.parser.JSONLexer;
import com.qx.wz.external.fastjson.parser.JSONReaderScanner;
import com.qx.wz.external.fastjson.util.IOUtils;
import com.qx.wz.external.fastjson.util.TypeUtils;
import java.io.Closeable;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;

public class JSONReader
implements Closeable {
    private final DefaultJSONParser parser;
    private JSONStreamContext context;

    public JSONReader(Reader reader) {
        JSONReaderScanner jSONReaderScanner;
        JSONReader jSONReader = closeable;
        Closeable closeable = jSONReaderScanner;
        jSONReaderScanner = new JSONReaderScanner(reader);
        jSONReader((JSONLexer)((Object)closeable));
    }

    public JSONReader(JSONLexer jSONLexer) {
        DefaultJSONParser defaultJSONParser;
        JSONReader jSONReader = closeable;
        Closeable closeable = defaultJSONParser;
        defaultJSONParser = new DefaultJSONParser(jSONLexer);
        jSONReader((DefaultJSONParser)closeable);
    }

    public JSONReader(DefaultJSONParser defaultJSONParser) {
        this.parser = defaultJSONParser;
    }

    private void startStructure() {
        switch (this.context.getState()) {
            default: {
                throw new JSONException("illegal state : " + this.context.getState());
            }
            case 1003: 
            case 1005: {
                this.parser.accept(16);
                return;
            }
            case 1002: {
                this.parser.accept(17);
                return;
            }
            case 1001: 
            case 1004: 
        }
    }

    private void endStructure() {
        JSONStreamContext jSONStreamContext;
        this.context = jSONStreamContext = this.context.getParent();
        if (jSONStreamContext == null) {
            return;
        }
        int n2 = -1;
        switch (jSONStreamContext.getState()) {
            default: {
                break;
            }
            case 1004: {
                n2 = 1005;
                break;
            }
            case 1002: {
                n2 = 1003;
                break;
            }
            case 1001: 
            case 1003: {
                n2 = 1002;
            }
        }
        if (n2 != -1) {
            this.context.setState(n2);
        }
    }

    private void readBefore() {
        int n2 = this.context.getState();
        switch (n2) {
            default: {
                throw new JSONException("illegal state : " + n2);
            }
            case 1005: {
                this.parser.accept(16);
                return;
            }
            case 1004: {
                return;
            }
            case 1003: {
                this.parser.accept(16, 18);
                return;
            }
            case 1002: {
                this.parser.accept(17);
                return;
            }
            case 1001: 
        }
    }

    private void readAfter() {
        int n2 = this.context.getState();
        int n3 = -1;
        switch (n2) {
            default: {
                throw new JSONException("illegal state : " + n2);
            }
            case 1004: {
                n3 = 1005;
                break;
            }
            case 1002: {
                n3 = 1003;
                break;
            }
            case 1001: 
            case 1003: {
                n3 = 1002;
            }
            case 1005: 
        }
        if (n3 != -1) {
            this.context.setState(n3);
        }
    }

    public void config(Feature feature, boolean bl) {
        this.parser.config(feature, bl);
    }

    public void startObject() {
        if (this.context == null) {
            JSONStreamContext jSONStreamContext;
            JSONStreamContext jSONStreamContext2 = jSONStreamContext;
            jSONStreamContext = new JSONStreamContext(null, 1001);
            this.context = jSONStreamContext2;
        } else {
            this.startStructure();
            this.context = new JSONStreamContext(this.context, 1001);
        }
        this.parser.accept(12, 18);
    }

    public void endObject() {
        JSONReader jSONReader = this;
        jSONReader.parser.accept(13);
        jSONReader.endStructure();
    }

    public void startArray() {
        if (this.context == null) {
            JSONStreamContext jSONStreamContext;
            JSONStreamContext jSONStreamContext2 = jSONStreamContext;
            jSONStreamContext = new JSONStreamContext(null, 1004);
            this.context = jSONStreamContext2;
        } else {
            this.startStructure();
            this.context = new JSONStreamContext(this.context, 1004);
        }
        this.parser.accept(14);
    }

    public void endArray() {
        JSONReader jSONReader = this;
        jSONReader.parser.accept(15);
        jSONReader.endStructure();
    }

    public boolean hasNext() {
        if (this.context != null) {
            JSONReader jSONReader = this;
            int n2 = jSONReader.parser.getLexer().token();
            int n3 = jSONReader.context.getState();
            switch (n3) {
                default: {
                    throw new JSONException("illegal state : " + n3);
                }
                case 1004: 
                case 1005: {
                    return n2 != 15;
                }
                case 1001: 
                case 1003: 
            }
            return n2 != 13;
        }
        throw new JSONException("context is null");
    }

    @Override
    public void close() {
        IOUtils.close(this.parser);
    }

    public Integer readInteger() {
        Object object;
        if (((JSONReader)object).context == null) {
            object = ((JSONReader)object).parser.parse();
        } else {
            JSONReader jSONReader = object;
            jSONReader.readBefore();
            object = jSONReader.parser.parse();
            jSONReader.readAfter();
        }
        return TypeUtils.castToInt(object);
    }

    public Long readLong() {
        Object object;
        if (((JSONReader)object).context == null) {
            object = ((JSONReader)object).parser.parse();
        } else {
            JSONReader jSONReader = object;
            jSONReader.readBefore();
            object = jSONReader.parser.parse();
            jSONReader.readAfter();
        }
        return TypeUtils.castToLong(object);
    }

    public String readString() {
        Object object;
        if (((JSONReader)object).context == null) {
            object = ((JSONReader)object).parser.parse();
        } else {
            JSONReader jSONReader = object;
            jSONReader.readBefore();
            object = jSONReader.parser.parse();
            jSONReader.readAfter();
        }
        return TypeUtils.castToString(object);
    }

    public <T> T readObject(TypeReference<T> typeReference) {
        return this.readObject(typeReference.getType());
    }

    public <T> T readObject(Type type) {
        if (this.context == null) {
            return this.parser.parseObject(type);
        }
        JSONReader jSONReader = this;
        jSONReader.readBefore();
        Object t2 = jSONReader.parser.parseObject(type);
        this.readAfter();
        return t2;
    }

    public <T> T readObject(Class<T> clazz) {
        if (this.context == null) {
            return this.parser.parseObject(clazz);
        }
        JSONReader jSONReader = this;
        jSONReader.readBefore();
        T t2 = jSONReader.parser.parseObject(clazz);
        this.readAfter();
        return t2;
    }

    public void readObject(Object object) {
        if (this.context == null) {
            this.parser.parseObject(object);
            return;
        }
        JSONReader jSONReader = this;
        jSONReader.readBefore();
        jSONReader.parser.parseObject(object);
        jSONReader.readAfter();
    }

    public Object readObject() {
        if (this.context == null) {
            return this.parser.parse();
        }
        JSONReader jSONReader = this;
        jSONReader.readBefore();
        int n2 = jSONReader.context.getState();
        Object object = n2 != 1001 && n2 != 1003 ? this.parser.parse() : this.parser.parseKey();
        this.readAfter();
        return object;
    }

    public Object readObject(Map map) {
        if (this.context == null) {
            return this.parser.parseObject(map);
        }
        JSONReader jSONReader = this;
        jSONReader.readBefore();
        Object object = jSONReader.parser.parseObject(map);
        this.readAfter();
        return object;
    }
}

