/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.serializer;

import com.qx.wz.external.fastjson.JSONException;
import com.qx.wz.external.fastjson.annotation.JSONField;
import com.qx.wz.external.fastjson.serializer.JSONSerializer;
import com.qx.wz.external.fastjson.serializer.SerializeWriter;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import com.qx.wz.external.fastjson.util.FieldInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public abstract class FieldSerializer {
    protected final FieldInfo fieldInfo;
    private final String double_quoted_fieldPrefix;
    private final String single_quoted_fieldPrefix;
    private final String un_quoted_fieldPrefix;
    private boolean writeNull;

    public FieldSerializer(FieldInfo serializerFeatureArray) {
        FieldSerializer fieldSerializer = this;
        this.writeNull = false;
        this.fieldInfo = serializerFeatureArray;
        serializerFeatureArray.setAccessible(true);
        fieldSerializer.double_quoted_fieldPrefix = "\"" + serializerFeatureArray.getName() + "\":";
        fieldSerializer.single_quoted_fieldPrefix = "'" + serializerFeatureArray.getName() + "':";
        fieldSerializer.un_quoted_fieldPrefix = serializerFeatureArray.getName() + ":";
        serializerFeatureArray = serializerFeatureArray.getAnnotation(JSONField.class);
        if (serializerFeatureArray != null) {
            serializerFeatureArray = serializerFeatureArray.serialzeFeatures();
            int n2 = serializerFeatureArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (serializerFeatureArray[i3] != SerializerFeature.WriteMapNullValue) continue;
                this.writeNull = true;
            }
        }
    }

    public boolean isWriteNull() {
        return this.writeNull;
    }

    public Field getField() {
        return this.fieldInfo.getField();
    }

    public String getName() {
        return this.fieldInfo.getName();
    }

    public Method getMethod() {
        return this.fieldInfo.getMethod();
    }

    public void writePrefix(JSONSerializer jSONSerializer) {
        JSONSerializer jSONSerializer2 = jSONSerializer;
        SerializeWriter serializeWriter = jSONSerializer2.getWriter();
        if (jSONSerializer2.isEnabled(SerializerFeature.QuoteFieldNames)) {
            if (jSONSerializer.isEnabled(SerializerFeature.UseSingleQuotes)) {
                serializeWriter.write(this.single_quoted_fieldPrefix);
                return;
            }
            serializeWriter.write(this.double_quoted_fieldPrefix);
            return;
        }
        serializeWriter.write(this.un_quoted_fieldPrefix);
    }

    public Object getPropertyValue(Object object) {
        try {
            return this.fieldInfo.get(object);
        }
        catch (Exception exception) {
            throw new JSONException("get property error\u3002 " + this.fieldInfo.gerQualifiedName(), exception);
        }
    }

    public abstract void writeProperty(JSONSerializer var1, Object var2);

    public abstract void writeValue(JSONSerializer var1, Object var2);
}

