/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.serializer;

import com.qx.wz.external.fastjson.parser.DefaultJSONParser;
import com.qx.wz.external.fastjson.parser.JSONLexer;
import com.qx.wz.external.fastjson.parser.deserializer.ObjectDeserializer;
import com.qx.wz.external.fastjson.serializer.JSONSerializer;
import com.qx.wz.external.fastjson.serializer.ObjectSerializer;
import com.qx.wz.external.fastjson.serializer.SerializeWriter;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import com.qx.wz.external.fastjson.util.TypeUtils;
import java.lang.reflect.Type;

public class FloatCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static FloatCodec instance = new FloatCodec();

    public static <T> T deserialze(DefaultJSONParser object) {
        JSONLexer jSONLexer = ((DefaultJSONParser)object).getLexer();
        if (jSONLexer.token() == 2) {
            JSONLexer jSONLexer2 = jSONLexer;
            object = jSONLexer2.numberString();
            jSONLexer2.nextToken(16);
            return (T)Float.valueOf(Float.parseFloat((String)object));
        }
        if (jSONLexer.token() == 3) {
            JSONLexer jSONLexer3 = jSONLexer;
            float f3 = jSONLexer3.floatValue();
            jSONLexer3.nextToken(16);
            return (T)Float.valueOf(f3);
        }
        if ((object = ((DefaultJSONParser)object).parse()) == null) {
            return null;
        }
        return (T)TypeUtils.castToFloat(object);
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type) {
        SerializeWriter serializeWriter = jSONSerializer.getWriter();
        if (object == null) {
            if (jSONSerializer.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
                serializeWriter.write('0');
                return;
            }
            serializeWriter.writeNull();
            return;
        }
        float f3 = ((Float)object).floatValue();
        if (Float.isNaN(f3)) {
            serializeWriter.writeNull();
            return;
        }
        if (Float.isInfinite(f3)) {
            serializeWriter.writeNull();
            return;
        }
        String string = Float.toString(f3);
        if (string.endsWith(".0")) {
            String string2 = string;
            string = string2.substring(0, string2.length() - 2);
        }
        serializeWriter.write(string);
        if (jSONSerializer.isEnabled(SerializerFeature.WriteClassName)) {
            serializeWriter.write('F');
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        return FloatCodec.deserialze(defaultJSONParser);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

