/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.serializer;

import com.qx.wz.external.fastjson.JSONAware;
import com.qx.wz.external.fastjson.JSONException;
import com.qx.wz.external.fastjson.JSONStreamAware;
import com.qx.wz.external.fastjson.serializer.AfterFilter;
import com.qx.wz.external.fastjson.serializer.ArraySerializer;
import com.qx.wz.external.fastjson.serializer.BeforeFilter;
import com.qx.wz.external.fastjson.serializer.CalendarCodec;
import com.qx.wz.external.fastjson.serializer.CharsetCodec;
import com.qx.wz.external.fastjson.serializer.CollectionSerializer;
import com.qx.wz.external.fastjson.serializer.DateSerializer;
import com.qx.wz.external.fastjson.serializer.EnumSerializer;
import com.qx.wz.external.fastjson.serializer.EnumerationSeriliazer;
import com.qx.wz.external.fastjson.serializer.ExceptionSerializer;
import com.qx.wz.external.fastjson.serializer.JSONAwareSerializer;
import com.qx.wz.external.fastjson.serializer.JSONSerializable;
import com.qx.wz.external.fastjson.serializer.JSONSerializableSerializer;
import com.qx.wz.external.fastjson.serializer.JSONStreamAwareSerializer;
import com.qx.wz.external.fastjson.serializer.ListSerializer;
import com.qx.wz.external.fastjson.serializer.MapSerializer;
import com.qx.wz.external.fastjson.serializer.NameFilter;
import com.qx.wz.external.fastjson.serializer.ObjectSerializer;
import com.qx.wz.external.fastjson.serializer.PropertyFilter;
import com.qx.wz.external.fastjson.serializer.PropertyPreFilter;
import com.qx.wz.external.fastjson.serializer.SerialContext;
import com.qx.wz.external.fastjson.serializer.SerializeConfig;
import com.qx.wz.external.fastjson.serializer.SerializeWriter;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import com.qx.wz.external.fastjson.serializer.StringCodec;
import com.qx.wz.external.fastjson.serializer.TimeZoneCodec;
import com.qx.wz.external.fastjson.serializer.ValueFilter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class JSONSerializer {
    private final SerializeConfig config;
    private final SerializeWriter out;
    private List<BeforeFilter> beforeFilters;
    private List<AfterFilter> afterFilters;
    private List<PropertyFilter> propertyFilters;
    private List<ValueFilter> valueFilters;
    private List<NameFilter> nameFilters;
    private List<PropertyPreFilter> propertyPreFilters;
    private int indentCount;
    private String indent;
    private String dateFormatPattern;
    private DateFormat dateFormat;
    private IdentityHashMap<Object, SerialContext> references;
    private SerialContext context;

    public JSONSerializer() {
        SerializeWriter serializeWriter;
        JSONSerializer jSONSerializer = serializeWriter2;
        SerializeWriter serializeWriter2 = serializeWriter;
        serializeWriter = new SerializeWriter();
        jSONSerializer(serializeWriter2, SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeWriter serializeWriter) {
        this(serializeWriter, SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeConfig serializeConfig) {
        SerializeWriter serializeWriter;
        JSONSerializer jSONSerializer = serializeWriter2;
        SerializeWriter serializeWriter2 = serializeWriter;
        serializeWriter = new SerializeWriter();
        jSONSerializer(serializeWriter2, serializeConfig);
    }

    public JSONSerializer(SerializeWriter serializeWriter, SerializeConfig serializeConfig) {
        this.beforeFilters = null;
        this.afterFilters = null;
        this.propertyFilters = null;
        this.valueFilters = null;
        this.nameFilters = null;
        this.propertyPreFilters = null;
        this.indentCount = 0;
        this.indent = "\t";
        this.references = null;
        this.out = serializeWriter;
        this.config = serializeConfig;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void write(Writer writer, Object object) {
        Throwable throwable2;
        SerializeWriter serializeWriter;
        SerializeWriter serializeWriter2 = serializeWriter;
        serializeWriter2();
        new JSONSerializer(serializeWriter2).write(object);
        serializeWriter.writeTo(writer);
        serializeWriter.close();
        return;
        {
            catch (Throwable throwable2) {
            }
            catch (IOException iOException) {}
            {
                throw new JSONException(iOException.getMessage(), iOException);
            }
        }
        serializeWriter2.close();
        throw throwable2;
    }

    public static final void write(SerializeWriter serializeWriter, Object object) {
        new JSONSerializer(serializeWriter).write(object);
    }

    public String getDateFormatPattern() {
        DateFormat dateFormat = this.dateFormat;
        if (dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)dateFormat).toPattern();
        }
        return this.dateFormatPattern;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null && this.dateFormatPattern != null) {
            this.dateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        if (this.dateFormatPattern != null) {
            this.dateFormatPattern = null;
        }
    }

    public void setDateFormat(String string) {
        this.dateFormatPattern = string;
        if (this.dateFormat != null) {
            this.dateFormat = null;
        }
    }

    public SerialContext getContext() {
        return this.context;
    }

    public void setContext(SerialContext serialContext) {
        this.context = serialContext;
    }

    public void setContext(SerialContext object, Object object2, Object object3, int n2) {
        if (this.isEnabled(SerializerFeature.DisableCircularReferenceDetect)) {
            return;
        }
        this.context = new SerialContext((SerialContext)object, object2, object3, n2);
        if (this.references == null) {
            IdentityHashMap identityHashMap;
            object = identityHashMap;
            identityHashMap = new IdentityHashMap();
            this.references = object;
        }
        this.references.put(object2, this.context);
    }

    public final boolean isWriteClassName(Type type, Object object) {
        if (!this.out.isEnabled(SerializerFeature.WriteClassName)) {
            return false;
        }
        return type != null || !this.isEnabled(SerializerFeature.NotWriteRootClassName) || !(this.context.getParent() == null);
    }

    public SerialContext getSerialContext(Object object) {
        IdentityHashMap<Object, SerialContext> identityHashMap = ((JSONSerializer)((Object)identityHashMap)).references;
        if (identityHashMap == null) {
            return null;
        }
        return (SerialContext)identityHashMap.get(object);
    }

    public boolean containsReference(Object object) {
        IdentityHashMap<Object, SerialContext> identityHashMap = ((JSONSerializer)((Object)identityHashMap)).references;
        if (identityHashMap == null) {
            return false;
        }
        return identityHashMap.containsKey(object);
    }

    public void writeReference(Object object) {
        SerialContext serialContext = ((JSONSerializer)((Object)string)).getContext();
        if (object == serialContext.getObject()) {
            ((JSONSerializer)((Object)string)).out.write("{\"$ref\":\"@\"}");
            return;
        }
        SerialContext serialContext2 = serialContext.getParent();
        if (serialContext2 != null && object == serialContext2.getObject()) {
            ((JSONSerializer)((Object)string)).out.write("{\"$ref\":\"..\"}");
            return;
        }
        while (serialContext.getParent() != null) {
            serialContext = serialContext.getParent();
        }
        if (object == serialContext.getObject()) {
            ((JSONSerializer)((Object)string)).out.write("{\"$ref\":\"$\"}");
            return;
        }
        JSONSerializer jSONSerializer = string;
        String string = jSONSerializer.getSerialContext(object).getPath();
        jSONSerializer.out.write("{\"$ref\":\"");
        jSONSerializer.out.write(string);
        jSONSerializer.out.write("\"}");
    }

    public List<ValueFilter> getValueFilters() {
        if (this.valueFilters == null) {
            ArrayList<ValueFilter> arrayList;
            ArrayList<ValueFilter> arrayList2 = arrayList;
            arrayList = new ArrayList<ValueFilter>();
            this.valueFilters = arrayList2;
        }
        return this.valueFilters;
    }

    public List<ValueFilter> getValueFiltersDirect() {
        return this.valueFilters;
    }

    public int getIndentCount() {
        return this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    public void decrementIdent() {
        --this.indentCount;
    }

    public void println() {
        this.out.write('\n');
        for (int i3 = 0; i3 < this.indentCount; ++i3) {
            this.out.write(this.indent);
        }
    }

    public List<BeforeFilter> getBeforeFilters() {
        if (this.beforeFilters == null) {
            ArrayList<BeforeFilter> arrayList;
            ArrayList<BeforeFilter> arrayList2 = arrayList;
            arrayList = new ArrayList<BeforeFilter>();
            this.beforeFilters = arrayList2;
        }
        return this.beforeFilters;
    }

    public List<BeforeFilter> getBeforeFiltersDirect() {
        return this.beforeFilters;
    }

    public List<AfterFilter> getAfterFilters() {
        if (this.afterFilters == null) {
            ArrayList<AfterFilter> arrayList;
            ArrayList<AfterFilter> arrayList2 = arrayList;
            arrayList = new ArrayList<AfterFilter>();
            this.afterFilters = arrayList2;
        }
        return this.afterFilters;
    }

    public List<AfterFilter> getAfterFiltersDirect() {
        return this.afterFilters;
    }

    public List<NameFilter> getNameFilters() {
        if (this.nameFilters == null) {
            ArrayList<NameFilter> arrayList;
            ArrayList<NameFilter> arrayList2 = arrayList;
            arrayList = new ArrayList<NameFilter>();
            this.nameFilters = arrayList2;
        }
        return this.nameFilters;
    }

    public List<NameFilter> getNameFiltersDirect() {
        return this.nameFilters;
    }

    public List<PropertyPreFilter> getPropertyPreFilters() {
        if (this.propertyPreFilters == null) {
            ArrayList<PropertyPreFilter> arrayList;
            ArrayList<PropertyPreFilter> arrayList2 = arrayList;
            arrayList = new ArrayList<PropertyPreFilter>();
            this.propertyPreFilters = arrayList2;
        }
        return this.propertyPreFilters;
    }

    public List<PropertyPreFilter> getPropertyPreFiltersDirect() {
        return this.propertyPreFilters;
    }

    public List<PropertyFilter> getPropertyFilters() {
        if (this.propertyFilters == null) {
            ArrayList<PropertyFilter> arrayList;
            ArrayList<PropertyFilter> arrayList2 = arrayList;
            arrayList = new ArrayList<PropertyFilter>();
            this.propertyFilters = arrayList2;
        }
        return this.propertyFilters;
    }

    public List<PropertyFilter> getPropertyFiltersDirect() {
        return this.propertyFilters;
    }

    public SerializeWriter getWriter() {
        return this.out;
    }

    public String toString() {
        return this.out.toString();
    }

    public void config(SerializerFeature serializerFeature, boolean bl) {
        this.out.config(serializerFeature, bl);
    }

    public boolean isEnabled(SerializerFeature serializerFeature) {
        return this.out.isEnabled(serializerFeature);
    }

    public void writeNull() {
        this.out.writeNull();
    }

    public SerializeConfig getMapping() {
        return this.config;
    }

    public final void write(Object object) {
        if (object == null) {
            this.out.writeNull();
            return;
        }
        try {
            this.getObjectWriter(object.getClass()).write(this, object, null, null);
            return;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeWithFieldName(Object object, Object object2) {
        this.writeWithFieldName(object, object2, null, 0);
    }

    protected final void writeKeyValue(char c3, String string, Object object) {
        if (c3 != '\u0000') {
            this.out.write(c3);
        }
        this.out.writeFieldName(string);
        this.write(object);
    }

    /*
     * Unable to fully structure code
     */
    public final void writeWithFieldName(Object var1_2, Object var2_3, Type var3_4, int var4_5) {
        if (var1_2 != null) ** GOTO lbl5
        try {
            this.out.writeNull();
            return;
lbl5:
            // 1 sources

            this.getObjectWriter(var1_2.getClass()).write(this, var1_2, var2_3, var3_4);
            return;
        }
        catch (IOException var0_1) {
            throw new JSONException(var0_1.getMessage(), var0_1);
        }
    }

    public final void writeWithFormat(Object object, String string) {
        if (object instanceof Date) {
            DateFormat dateFormat = ((JSONSerializer)((Object)string2)).getDateFormat();
            if (dateFormat == null) {
                SimpleDateFormat simpleDateFormat;
                dateFormat = simpleDateFormat;
                simpleDateFormat = new SimpleDateFormat(string);
            }
            JSONSerializer jSONSerializer = string2;
            String string2 = dateFormat.format((Date)object);
            jSONSerializer.out.writeString(string2);
            return;
        }
        ((JSONSerializer)((Object)string2)).write(object);
    }

    public final void write(String string) {
        StringCodec.instance.write(this, string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        int n2;
        Class<?>[] classArray;
        boolean bl;
        boolean bl2;
        Object object = (ObjectSerializer)this.config.get(clazz);
        if (object != null) return object;
        if (Map.class.isAssignableFrom(clazz)) {
            this.config.put(clazz, MapSerializer.instance);
            return (ObjectSerializer)this.config.get(clazz);
        }
        if (List.class.isAssignableFrom(clazz)) {
            this.config.put(clazz, ListSerializer.instance);
            return (ObjectSerializer)this.config.get(clazz);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            this.config.put(clazz, CollectionSerializer.instance);
            return (ObjectSerializer)this.config.get(clazz);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            this.config.put(clazz, DateSerializer.instance);
            return (ObjectSerializer)this.config.get(clazz);
        }
        if (JSONAware.class.isAssignableFrom(clazz)) {
            this.config.put(clazz, JSONAwareSerializer.instance);
            return (ObjectSerializer)this.config.get(clazz);
        }
        if (JSONSerializable.class.isAssignableFrom(clazz)) {
            this.config.put(clazz, JSONSerializableSerializer.instance);
            return (ObjectSerializer)this.config.get(clazz);
        }
        if (JSONStreamAware.class.isAssignableFrom(clazz)) {
            this.config.put(clazz, JSONStreamAwareSerializer.instance);
            return (ObjectSerializer)this.config.get(clazz);
        }
        if (!(clazz.isEnum() || clazz.getSuperclass() != null && clazz.getSuperclass().isEnum())) {
            if (clazz.isArray()) {
                ArraySerializer arraySerializer;
                JSONSerializer jSONSerializer = this;
                object = clazz.getComponentType();
                ObjectSerializer objectSerializer = jSONSerializer.getObjectWriter((Class<?>)object);
                ArraySerializer arraySerializer2 = arraySerializer;
                arraySerializer = new ArraySerializer((Class<?>)object, objectSerializer);
                jSONSerializer.config.put(clazz, arraySerializer2);
                return (ObjectSerializer)this.config.get(clazz);
            }
            if (Throwable.class.isAssignableFrom(clazz)) {
                ExceptionSerializer exceptionSerializer;
                object = exceptionSerializer;
                exceptionSerializer = new ExceptionSerializer(clazz);
                this.config.put(clazz, object);
                return (ObjectSerializer)this.config.get(clazz);
            }
            if (TimeZone.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, TimeZoneCodec.instance);
                return (ObjectSerializer)this.config.get(clazz);
            }
            if (Charset.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, CharsetCodec.instance);
                return (ObjectSerializer)this.config.get(clazz);
            }
            if (Enumeration.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, EnumerationSeriliazer.instance);
                return (ObjectSerializer)this.config.get(clazz);
            }
            if (Calendar.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, CalendarCodec.instance);
                return (ObjectSerializer)this.config.get(clazz);
            }
            bl2 = false;
            bl = false;
            classArray = clazz.getInterfaces();
            n2 = classArray.length;
        } else {
            this.config.put(clazz, EnumSerializer.instance);
            return (ObjectSerializer)this.config.get(clazz);
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            Class<?> clazz2 = classArray[i3];
            if (!clazz2.getName().equals("net.sf.cglib.proxy.Factory") && !clazz2.getName().equals("org.springframework.cglib.proxy.Factory")) {
                if (!clazz2.getName().equals("javassist.util.proxy.ProxyObject")) continue;
                bl = true;
                break;
            }
            bl2 = true;
            break;
        }
        if (!bl2 && !bl) {
            if (Proxy.isProxyClass(clazz)) {
                SerializeConfig serializeConfig = this.config;
                serializeConfig.put(clazz, serializeConfig.createJavaBeanSerializer(clazz));
                return (ObjectSerializer)this.config.get(clazz);
            } else {
                SerializeConfig serializeConfig = this.config;
                serializeConfig.put(clazz, serializeConfig.createJavaBeanSerializer(clazz));
            }
            return (ObjectSerializer)this.config.get(clazz);
        }
        ObjectSerializer objectSerializer = this.getObjectWriter(clazz.getSuperclass());
        this.config.put(clazz, objectSerializer);
        return objectSerializer;
    }

    public void close() {
        this.out.close();
    }
}

