/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.serializer;

import com.qx.wz.external.fastjson.parser.DefaultJSONParser;
import com.qx.wz.external.fastjson.parser.deserializer.ObjectDeserializer;
import com.qx.wz.external.fastjson.serializer.JSONSerializer;
import com.qx.wz.external.fastjson.serializer.ObjectSerializer;
import com.qx.wz.external.fastjson.serializer.SerializeWriter;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import com.qx.wz.external.fastjson.util.TypeUtils;
import java.lang.reflect.Type;

public class LongCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static LongCodec instance = new LongCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type) {
        SerializeWriter serializeWriter = jSONSerializer.getWriter();
        if (object == null) {
            if (serializeWriter.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
                serializeWriter.write('0');
                return;
            }
            serializeWriter.writeNull();
            return;
        }
        long l2 = (Long)object;
        serializeWriter.writeLong(l2);
        if (jSONSerializer.isEnabled(SerializerFeature.WriteClassName) && l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE && type != Long.class) {
            serializeWriter.write('L');
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Long l2;
        Object object2 = defaultJSONParser.getLexer();
        if (object2.token() == 2) {
            long l3 = object2.longValue();
            object2.nextToken(16);
            l2 = l3;
        } else {
            object2 = defaultJSONParser.parse();
            if (object2 == null) {
                return null;
            }
            l2 = TypeUtils.castToLong(object2);
        }
        return (T)l2;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

