/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.util;

import com.qx.wz.external.fastjson.JSON;
import com.qx.wz.external.fastjson.JSONException;
import com.qx.wz.external.fastjson.JSONObject;
import com.qx.wz.external.fastjson.annotation.JSONField;
import com.qx.wz.external.fastjson.annotation.JSONType;
import com.qx.wz.external.fastjson.parser.Feature;
import com.qx.wz.external.fastjson.parser.JSONScanner;
import com.qx.wz.external.fastjson.parser.ParserConfig;
import com.qx.wz.external.fastjson.parser.deserializer.FieldDeserializer;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import com.qx.wz.external.fastjson.util.Base64;
import com.qx.wz.external.fastjson.util.FieldInfo;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TypeUtils {
    public static boolean compatibleWithJavaBean = false;
    private static boolean setAccessibleEnable = true;
    private static ConcurrentMap<String, Class<?>> mappings = new ConcurrentHashMap();

    public static final String castToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static final Byte castToByte(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            if (((String)(object = (String)object)).length() == 0) {
                return null;
            }
            return Byte.parseByte((String)object);
        }
        throw new JSONException("can not cast to byte, value : " + object);
    }

    public static final Character castToChar(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            if (string.length() == 1) {
                return Character.valueOf(string.charAt(0));
            }
            throw new JSONException("can not cast to byte, value : " + object);
        }
        throw new JSONException("can not cast to byte, value : " + object);
    }

    public static final Short castToShort(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        if (object instanceof String) {
            if (((String)(object = (String)object)).length() == 0) {
                return null;
            }
            return Short.parseShort((String)object);
        }
        throw new JSONException("can not cast to short, value : " + object);
    }

    public static final BigDecimal castToBigDecimal(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof BigInteger) {
            return new BigDecimal((BigInteger)object);
        }
        if (((String)(object = object.toString())).length() == 0) {
            return null;
        }
        return new BigDecimal((String)object);
    }

    public static final BigInteger castToBigInteger(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (!(object instanceof Float) && !(object instanceof Double)) {
            if (((String)(object = object.toString())).length() == 0) {
                return null;
            }
            return new BigInteger((String)object);
        }
        return BigInteger.valueOf(((Number)object).longValue());
    }

    public static final Float castToFloat(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        if (object instanceof String) {
            if (((String)(object = object.toString())).length() == 0) {
                return null;
            }
            return Float.valueOf(Float.parseFloat((String)object));
        }
        throw new JSONException("can not cast to float, value : " + object);
    }

    public static final Double castToDouble(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            if (((String)(object = object.toString())).length() == 0) {
                return null;
            }
            return Double.parseDouble((String)object);
        }
        throw new JSONException("can not cast to double, value : " + object);
    }

    public static final java.util.Date castToDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        if (object instanceof java.util.Date) {
            return (java.util.Date)object;
        }
        long l2 = -1L;
        if (object instanceof Number) {
            l2 = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.indexOf(45) != -1) {
                object = string.length() == JSON.DEFFAULT_DATE_FORMAT.length() ? JSON.DEFFAULT_DATE_FORMAT : (string.length() == 10 ? "yyyy-MM-dd" : (string.length() == 19 ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd HH:mm:ss.SSS"));
                try {
                    return new SimpleDateFormat((String)object).parse(string);
                }
                catch (ParseException parseException) {
                    throw new JSONException("can not cast to Date, value : " + string);
                }
            }
            if (string.length() == 0) {
                return null;
            }
            l2 = Long.parseLong(string);
        }
        if (l2 >= 0L) {
            return new java.util.Date(l2);
        }
        throw new JSONException("can not cast to Date, value : " + object);
    }

    public static final Date castToSqlDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return new Date(((Calendar)object).getTimeInMillis());
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof java.util.Date) {
            return new Date(((java.util.Date)object).getTime());
        }
        long l2 = 0L;
        if (object instanceof Number) {
            l2 = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            l2 = Long.parseLong(string);
        }
        if (l2 > 0L) {
            return new Date(l2);
        }
        throw new JSONException("can not cast to Date, value : " + object);
    }

    public static final Timestamp castToTimestamp(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return new Timestamp(((Calendar)object).getTimeInMillis());
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        long l2 = 0L;
        if (object instanceof Number) {
            l2 = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            l2 = Long.parseLong(string);
        }
        if (l2 > 0L) {
            return new Timestamp(l2);
        }
        throw new JSONException("can not cast to Date, value : " + object);
    }

    public static final Long castToLong(Object object) {
        block7: {
            if (object == null) {
                return null;
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            if (object instanceof String) {
                Object object2 = (String)object;
                if (((String)object2).length() == 0) {
                    return null;
                }
                try {
                    return Long.parseLong((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    JSONScanner jSONScanner;
                    JSONScanner jSONScanner2 = jSONScanner;
                    jSONScanner = new JSONScanner((String)object2);
                    object2 = null;
                    if (jSONScanner.scanISO8601DateIfMatch(false)) {
                        object2 = jSONScanner2.getCalendar();
                    }
                    jSONScanner2.close();
                    if (object2 == null) break block7;
                    return ((Calendar)object2).getTimeInMillis();
                }
            }
        }
        throw new JSONException("can not cast to long, value : " + object);
    }

    public static final Integer castToInt(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            if (((String)(object = (String)object)).length() == 0) {
                return null;
            }
            return Integer.parseInt((String)object);
        }
        throw new JSONException("can not cast to int, value : " + object);
    }

    public static final byte[] castToBytes(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return Base64.decodeFast((String)object);
        }
        throw new JSONException("can not cast to int, value : " + object);
    }

    public static final Boolean castToBoolean(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() == 1;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            if ("true".equals(string)) {
                return Boolean.TRUE;
            }
            if ("false".equals(string)) {
                return Boolean.FALSE;
            }
            if ("1".equals(string)) {
                return Boolean.TRUE;
            }
            if ("0".equals(string)) {
                return Boolean.FALSE;
            }
        }
        throw new JSONException("can not cast to int, value : " + object);
    }

    public static final <T> T castToJavaBean(Object object, Class<T> clazz) {
        return TypeUtils.cast(object, clazz, ParserConfig.getGlobalInstance());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final <T> T cast(Object object, Class<T> serializable, ParserConfig parserConfig) {
        if (object == null) {
            return null;
        }
        if (serializable == null) throw new IllegalArgumentException("clazz is null");
        if (serializable == object.getClass()) {
            return (T)object;
        }
        if (object instanceof Map) {
            if (serializable == Map.class) {
                return (T)object;
            }
            Map map = (Map)object;
            if (serializable != Object.class) return TypeUtils.castToJavaBean(map, serializable, parserConfig);
            if (map.containsKey(JSON.DEFAULT_TYPE_KEY)) return TypeUtils.castToJavaBean(map, serializable, parserConfig);
            return (T)object;
        }
        if (((Class)serializable).isArray()) {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                int n2 = 0;
                Object object2 = Array.newInstance(((Class)serializable).getComponentType(), collection.size());
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Array.set(object2, n2, TypeUtils.cast(iterator.next(), ((Class)serializable).getComponentType(), parserConfig));
                    ++n2;
                }
                return (T)object2;
            }
            if (serializable == byte[].class) {
                return (T)TypeUtils.castToBytes(object);
            }
        }
        if (((Class)serializable).isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        if (serializable == Boolean.TYPE) return (T)TypeUtils.castToBoolean(object);
        if (serializable == Boolean.class) {
            return (T)TypeUtils.castToBoolean(object);
        }
        if (serializable == Byte.TYPE) return (T)TypeUtils.castToByte(object);
        if (serializable == Byte.class) {
            return (T)TypeUtils.castToByte(object);
        }
        if (serializable == Short.TYPE) return (T)TypeUtils.castToShort(object);
        if (serializable == Short.class) {
            return (T)TypeUtils.castToShort(object);
        }
        if (serializable == Integer.TYPE) return (T)TypeUtils.castToInt(object);
        if (serializable == Integer.class) {
            return (T)TypeUtils.castToInt(object);
        }
        if (serializable == Long.TYPE) return (T)TypeUtils.castToLong(object);
        if (serializable == Long.class) {
            return (T)TypeUtils.castToLong(object);
        }
        if (serializable == Float.TYPE) return (T)TypeUtils.castToFloat(object);
        if (serializable == Float.class) {
            return (T)TypeUtils.castToFloat(object);
        }
        if (serializable == Double.TYPE) return (T)TypeUtils.castToDouble(object);
        if (serializable == Double.class) {
            return (T)TypeUtils.castToDouble(object);
        }
        if (serializable == String.class) {
            return (T)TypeUtils.castToString(object);
        }
        if (serializable == BigDecimal.class) {
            return (T)TypeUtils.castToBigDecimal(object);
        }
        if (serializable == BigInteger.class) {
            return (T)TypeUtils.castToBigInteger(object);
        }
        if (serializable == java.util.Date.class) {
            return (T)TypeUtils.castToDate(object);
        }
        if (serializable == Date.class) {
            return (T)TypeUtils.castToSqlDate(object);
        }
        if (serializable == Timestamp.class) {
            return (T)TypeUtils.castToTimestamp(object);
        }
        if (((Class)serializable).isEnum()) {
            return TypeUtils.castToEnum(object, serializable, parserConfig);
        }
        if (!Calendar.class.isAssignableFrom((Class<?>)serializable)) {
            if (!(object instanceof String)) throw new JSONException("can not cast to : " + ((Class)serializable).getName());
            if (((String)object).length() != 0) throw new JSONException("can not cast to : " + ((Class)serializable).getName());
            return null;
        }
        object = TypeUtils.castToDate(object);
        if (serializable == Calendar.class) {
            serializable = Calendar.getInstance();
        } else {
            try {
                serializable = (Calendar)((Class)serializable).newInstance();
            }
            catch (Exception exception) {
                throw new JSONException("can not cast to : " + ((Class)serializable).getName(), exception);
            }
        }
        Serializable serializable2 = serializable;
        ((Calendar)serializable2).setTime((java.util.Date)object);
        return (T)serializable2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final <T> T castToEnum(Object object, Class<T> clazz, ParserConfig objectArray) {
        block8: {
            Enum enum_;
            int n2;
            try {
                if (object instanceof String) {
                    if (((String)(object = (String)object)).length() == 0) {
                        return null;
                    }
                    return Enum.valueOf(clazz, (String)object);
                }
                if (!(object instanceof Number)) break block8;
                n2 = ((Number)object).intValue();
                objectArray = (Object[])clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                int n3 = objectArray.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    enum_ = (Enum)objectArray[i3];
                }
            }
            catch (Exception exception) {
                throw new JSONException("can not cast to : " + clazz.getName(), exception);
            }
            {
                if (enum_.ordinal() != n2) continue;
                return (T)enum_;
            }
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static final <T> T cast(Object object, Type type, ParserConfig parserConfig) {
        if (object == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtils.cast(object, (Class)type, parserConfig);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.cast(object, (ParameterizedType)type, parserConfig);
        }
        if (object instanceof String && ((String)object).length() == 0) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return (T)object;
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static final <T> T cast(Object object, ParameterizedType iterator, ParserConfig parserConfig) {
        Type type;
        Type object22 = iterator.getRawType();
        if (object22 == Set.class || object22 == HashSet.class || object22 == TreeSet.class || object22 == List.class || object22 == ArrayList.class) {
            type = iterator.getActualTypeArguments()[0];
            if (object instanceof Iterable) {
                if (object22 != Set.class && object22 != HashSet.class) {
                    if (object22 == TreeSet.class) {
                        TreeSet treeSet;
                        iterator = treeSet;
                        treeSet = new TreeSet();
                    } else {
                        ArrayList arrayList;
                        iterator = arrayList;
                        arrayList = new ArrayList();
                    }
                } else {
                    HashSet hashSet;
                    iterator = hashSet;
                    hashSet = new HashSet();
                }
                object = ((Iterable)object).iterator();
                while (object.hasNext()) {
                    iterator.add(TypeUtils.cast(object.next(), type, parserConfig));
                }
                return (T)iterator;
            }
        }
        if (object22 == Map.class || object22 == HashMap.class) {
            Iterator iterator2 = iterator;
            type = iterator2.getActualTypeArguments()[0];
            Type type2 = iterator2.getActualTypeArguments()[1];
            if (object instanceof Map) {
                HashMap hashMap;
                Iterator iterator3 = object;
                object = hashMap;
                hashMap = new HashMap();
                for (Map.Entry entry : ((Map)((Object)iterator3)).entrySet()) {
                    object.put(TypeUtils.cast(entry.getKey(), type, parserConfig), TypeUtils.cast(entry.getValue(), type2, parserConfig));
                }
                return (T)object;
            }
        }
        if (object instanceof String && ((String)object).length() == 0) {
            return null;
        }
        if (iterator.getActualTypeArguments().length == 1 && iterator.getActualTypeArguments()[0] instanceof WildcardType) {
            return TypeUtils.cast(object, object22, parserConfig);
        }
        throw new JSONException("can not cast to : " + iterator);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final <T> T castToJavaBean(Map<String, Object> var0, Class<T> var1_2, ParserConfig var2_3) {
        block40: {
            block41: {
                block39: {
                    block38: {
                        if (var1_2 != StackTraceElement.class) ** GOTO lbl24
                        v0 = var0;
                        v1 = v0;
                        v2 = v0;
                        v3 = v0;
                        var0 = (String)v0.get("className");
                        var1_2 = (String)v1.get("methodName");
                        var2_3 = (String)v2.get("fileName");
                        var3_4 = (Number)v3.get("lineNumber");
                        if (var3_4 != null) break block38;
                        var3_5 = 0;
                        break block39;
                    }
                    var3_5 = var3_4.intValue();
                }
                return (T)new StackTraceElement((String)var0, (String)var1_2, (String)var2_3, var3_5);
lbl24:
                // 1 sources

                var3_6 = var0.get(JSON.DEFAULT_TYPE_KEY);
                if (!(var3_6 instanceof String)) ** GOTO lbl41
                var3_6 = (String)var3_6;
                var4_7 = TypeUtils.loadClass((String)var3_6);
                if (var4_7 == null) ** GOTO lbl36
                if (var4_7.equals(var1_2)) ** GOTO lbl41
                return (T)TypeUtils.castToJavaBean((Map<String, Object>)var0, var4_7, (ParserConfig)var2_3);
lbl36:
                // 1 sources

                v4 = v5;
                v6 = v5;
                v4(var3_6 + " not found");
                throw v6;
lbl41:
                // 2 sources

                if (!var1_2.isInterface()) break block40;
                if (!(var0 instanceof JSONObject)) break block41;
                var2_3 = var0 = (JSONObject)var0;
                ** GOTO lbl51
            }
            var2_3 = v7;
            v7 = new JSONObject((Map<String, Object>)var0);
lbl51:
            // 2 sources

            v8 = Thread.currentThread().getContextClassLoader();
            v9 = new Class[1];
            v9[0] = var1_2;
            return (T)Proxy.newProxyInstance(v8, v9, (InvocationHandler)var2_3);
        }
        if (var2_3 == null) {
            var2_3 = ParserConfig.getGlobalInstance();
        }
        v10 = var1_2;
        var1_2 = var2_3.getFieldDeserializers((Class<?>)var1_2);
        var3_6 = v10.getDeclaredConstructor(new Class[0]);
        if (var3_6.isAccessible()) ** GOTO lbl69
        var3_6.setAccessible(true);
lbl69:
        // 2 sources

        v11 = var1_2;
        var1_2 = var3_6.newInstance(new Object[0]);
        try {
            var3_6 = v11.entrySet().iterator();
        }
        catch (Exception var0_1) {
            throw new JSONException(var0_1.getMessage(), var0_1);
        }
        while (true) {
            block42: {
                if (!var3_6.hasNext()) break;
                v12 = var0;
                var4_7 = (Map.Entry)var3_6.next();
                var5_8 /* !! */  = (String)var4_7.getKey();
                var4_7 = (FieldDeserializer)var4_7.getValue();
                if (!v12.containsKey(var5_8 /* !! */ )) continue;
                v13 = var4_7;
                var5_8 /* !! */  = var0.get(var5_8 /* !! */ );
                var6_9 = v13.getMethod();
                if (var6_9 == null) break block42;
                v14 = var6_9;
                v15 = var1_2;
                var4_7 = TypeUtils.cast((Object)var5_8 /* !! */ , var6_9.getGenericParameterTypes()[0], (ParserConfig)var2_3);
                v14.invoke(v15, new Object[]{var4_7});
                continue;
            }
            var4_7 = var4_7.getField();
            var4_7.set(var1_2, TypeUtils.cast((Object)var5_8 /* !! */ , var4_7.getGenericType(), (ParserConfig)var2_3));
            continue;
            break;
        }
        return (T)var1_2;
    }

    public static void addClassMapping(String string, Class<?> clazz) {
        if (string == null) {
            string = clazz.getName();
        }
        mappings.put(string, clazz);
    }

    public static void addBaseClassMappings() {
        mappings.put("byte", Byte.TYPE);
        mappings.put("short", Short.TYPE);
        mappings.put("int", Integer.TYPE);
        mappings.put("long", Long.TYPE);
        mappings.put("float", Float.TYPE);
        mappings.put("double", Double.TYPE);
        mappings.put("boolean", Boolean.TYPE);
        mappings.put("char", Character.TYPE);
        mappings.put("[byte", byte[].class);
        mappings.put("[short", short[].class);
        mappings.put("[int", int[].class);
        mappings.put("[long", long[].class);
        mappings.put("[float", float[].class);
        mappings.put("[double", double[].class);
        mappings.put("[boolean", boolean[].class);
        mappings.put("[char", char[].class);
        mappings.put(HashMap.class.getName(), HashMap.class);
    }

    public static void clearClassMapping() {
        mappings.clear();
        TypeUtils.addBaseClassMappings();
    }

    public static Class<?> loadClass(String string) {
        while (string != null && string.length() != 0) {
            Class<?> clazz;
            block11: {
                ClassLoader classLoader;
                clazz = (Class<?>)mappings.get(string);
                if (clazz != null) {
                    return clazz;
                }
                if (string.charAt(0) == '[') {
                    return Array.newInstance(TypeUtils.loadClass(string.substring(1)), 0).getClass();
                }
                if (string.startsWith("L") && string.endsWith(";")) {
                    String string2 = string;
                    string = string2.substring(1, string2.length() - 1);
                    continue;
                }
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) break block11;
                }
                catch (Throwable throwable) {}
                clazz = classLoader.loadClass(string);
                TypeUtils.addClassMapping(string, clazz);
                return clazz;
            }
            try {
                clazz = Class.forName(string);
            }
            catch (Throwable throwable) {
                return clazz;
            }
            TypeUtils.addClassMapping(string, clazz);
            return clazz;
        }
        return null;
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> map) {
        return TypeUtils.computeGetters(clazz, map, true);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static List<FieldInfo> computeGetters(Class<?> var0, Map<String, String> var1_1, boolean var2_4) {
        block30: {
            var3_5 = v0;
            v0 = new LinkedHashMap<Object, Object>();
            for (AccessibleObject var7_11 : var0.getMethods()) {
                var8_12 = var7_11.getName();
                var9_13 = 0;
                var10_14 = 0;
                if (Modifier.isStatic(var7_11.getModifiers()) || var7_11.getReturnType().equals(Void.TYPE) || var7_11.getParameterTypes().length != 0 || var7_11.getReturnType() == ClassLoader.class || var7_11.getName().equals("getMetaClass") && var7_11.getReturnType().getName().equals("groovy.lang.MetaClass")) continue;
                var11_15 = var7_11.getAnnotation(JSONField.class);
                if (var11_15 == null) {
                    var11_15 = TypeUtils.getSupperMethodAnnotation(var0, (Method)var7_11);
                }
                if (var11_15 != null) {
                    if (!var11_15.serialize()) continue;
                    v1 = var11_15;
                    var9_13 = v1.ordinal();
                    var10_14 = SerializerFeature.of(v1.serialzeFeatures());
                    if (v1.name().length() != 0) {
                        var8_12 = var11_15.name();
                        if (var1_1 != null && (var8_12 = var1_1.get(var8_12)) == null) continue;
                        var11_15 = v2;
                        v2 = new FieldInfo((String)var8_12, (Method)var7_11, null, var9_13, var10_14);
                        var3_5.put(var8_12, var11_15);
                        continue;
                    }
                }
                if (var8_12.startsWith("get")) {
                    if (var8_12.length() < 4 || var8_12.equals("getClass")) continue;
                    var11_16 = var8_12.charAt(3);
                    if (Character.isUpperCase(var11_16)) {
                        var11_15 = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(var8_12.substring(3)) : Character.toLowerCase(var8_12.charAt(3)) + var8_12.substring(4);
                    } else if (var11_16 == '_') {
                        var11_15 = var8_12.substring(4);
                    } else if (var11_16 == 'f') {
                        var11_15 = var8_12.substring(3);
                    } else {
                        if (var8_12.length() < 5 || !Character.isUpperCase(var8_12.charAt(4))) continue;
                        var11_15 = TypeUtils.decapitalize(var8_12.substring(3));
                    }
                    if (TypeUtils.isJSONTypeIgnore(var0, (String)var11_15)) continue;
                    var12_20 = ParserConfig.getField(var0, (String)var11_15);
                    if (var12_20 != null && (var13_21 = var12_20.getAnnotation(JSONField.class)) != null) {
                        if (!var13_21.serialize()) continue;
                        v3 = var13_21;
                        var9_13 = v3.ordinal();
                        var10_14 = SerializerFeature.of(v3.serialzeFeatures());
                        if (v3.name().length() != 0) {
                            var11_15 = var13_21.name();
                            if (var1_1 != null && (var11_15 = var1_1.get(var11_15)) == null) continue;
                        }
                    }
                    if (var1_1 != null && (var11_15 = var1_1.get(var11_15)) == null) continue;
                    var13_21 = v4;
                    v4 = new FieldInfo((String)var11_15, (Method)var7_11, var12_20, var9_13, var10_14);
                    var3_5.put(var11_15, var13_21);
                }
                if (!var8_12.startsWith("is") || var8_12.length() < 3) continue;
                var11_17 = var8_12.charAt(2);
                if (Character.isUpperCase(var11_17)) {
                    var11_18 = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(var8_12.substring(2)) : Character.toLowerCase(var8_12.charAt(2)) + var8_12.substring(3);
                } else if (var11_17 == '_') {
                    var11_18 = var8_12.substring(3);
                } else {
                    if (var11_17 != 'f') continue;
                    var11_18 = var8_12.substring(2);
                }
                var12_20 = ParserConfig.getField(var0, var11_18);
                if (var12_20 == null) {
                    var12_20 = ParserConfig.getField(var0, (String)var8_12);
                }
                if (var12_20 != null && (var8_12 = var12_20.getAnnotation(JSONField.class)) != null) {
                    if (!var8_12.serialize()) continue;
                    v5 = var8_12;
                    var9_13 = v5.ordinal();
                    var10_14 = SerializerFeature.of(v5.serialzeFeatures());
                    if (v5.name().length() != 0) {
                        var11_18 = var8_12.name();
                        if (var1_1 != null && (var11_18 = var1_1.get(var11_18)) == null) continue;
                    }
                }
                if (var1_1 != null && (var11_18 = var1_1.get(var11_18)) == null) continue;
                var8_12 = v6;
                v6 = new FieldInfo(var11_18, (Method)var7_11, var12_20, var9_13, var10_14);
                var3_5.put(var11_18, var8_12);
            }
            for (AccessibleObject var7_11 : var0.getFields()) {
                if (Modifier.isStatic(var7_11.getModifiers())) continue;
                var8_12 = var7_11.getAnnotation(JSONField.class);
                var9_13 = 0;
                var10_14 = 0;
                var11_19 = var7_11.getName();
                if (var8_12 != null) {
                    if (!var8_12.serialize()) continue;
                    v7 = var8_12;
                    var9_13 = v7.ordinal();
                    var10_14 = SerializerFeature.of(v7.serialzeFeatures());
                    if (v7.name().length() != 0) {
                        var11_19 = var8_12.name();
                    }
                }
                if (var1_1 != null && (var11_19 = var1_1.get(var11_19)) == null || var3_5.containsKey(var11_19)) continue;
                var8_12 = v8;
                v8 = new FieldInfo(var11_19, null, (Field)var7_11, var9_13, var10_14);
                var3_5.put(var11_19, var8_12);
            }
            v9 = var0;
            var0 = v10;
            v10 = new ArrayList<E>();
            var1_2 = 0;
            var4_6 = null;
            var5_8 = v9.getAnnotation(JSONType.class);
            if (var5_8 == null) break block30;
            var4_6 = var5_8.orders();
            if (var4_6 == null || var4_6.length != var3_5.size()) ** GOTO lbl113
            var1_2 = 1;
            var5_9 = var4_6.length;
            for (var6_10 = 0; var6_10 < var5_9; ++var6_10) {
                if (var3_5.containsKey(var4_6[var6_10])) {
                    continue;
                }
lbl113:
                // 3 sources

                var1_2 = 0;
                break;
            }
        }
        if (var1_2 != 0) {
            var1_2 = var4_6.length;
            for (var2_4 = 0; var2_4 < var1_2; ++var2_4) {
                var0.add((FieldInfo)var3_5.get(var4_6[var2_4]));
            }
        } else {
            var1_3 = var3_5.values().iterator();
            while (var1_3.hasNext()) {
                var0.add((FieldInfo)((FieldInfo)var1_3.next()));
            }
            if (var2_4 != 0) {
                Collections.sort(var0);
            }
        }
        return var0;
    }

    public static JSONField getSupperMethodAnnotation(Class<?> classArray, Method method) {
        classArray = classArray.getInterfaces();
        int n2 = classArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            for (Method method2 : classArray[i3].getMethods()) {
                JSONField jSONField;
                if (!method2.getName().equals(method.getName()) || method2.getParameterTypes().length != method.getParameterTypes().length) continue;
                boolean bl = true;
                for (int i4 = 0; i4 < method2.getParameterTypes().length; ++i4) {
                    if (method2.getParameterTypes()[i4].equals(method.getParameterTypes()[i4])) continue;
                    bl = false;
                    break;
                }
                if (!bl || (jSONField = method2.getAnnotation(JSONField.class)) == null) continue;
                return jSONField;
            }
        }
        return null;
    }

    private static boolean isJSONTypeIgnore(Class<?> clazz, String string) {
        String[] stringArray = clazz.getAnnotation(JSONType.class);
        if (stringArray != null && stringArray.ignores() != null) {
            stringArray = stringArray.ignores();
            int n2 = stringArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!string.equalsIgnoreCase(stringArray[i3])) continue;
                return true;
            }
        }
        return clazz.getSuperclass() != Object.class && clazz.getSuperclass() != null && TypeUtils.isJSONTypeIgnore(clazz.getSuperclass(), string);
    }

    public static boolean isGenericParamType(Type type) {
        while (true) {
            if (type instanceof ParameterizedType) {
                return true;
            }
            if (!(type instanceof Class)) break;
            type = ((Class)type).getGenericSuperclass();
        }
        return false;
    }

    public static Type getGenericParamType(Type type) {
        while (true) {
            if (type instanceof ParameterizedType) {
                return type;
            }
            if (!(type instanceof Class)) break;
            type = ((Class)type).getGenericSuperclass();
        }
        return type;
    }

    public static Type unwrap(Type type) {
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            if (type2 == Byte.TYPE) {
                return byte[].class;
            }
            if (type2 == Character.TYPE) {
                return char[].class;
            }
        }
        return type;
    }

    public static Class<?> getClass(Type type) {
        while (true) {
            if (type.getClass() == Class.class) {
                return (Class)type;
            }
            if (!(type instanceof ParameterizedType)) break;
            type = ((ParameterizedType)type).getRawType();
        }
        return Object.class;
    }

    public static Field getField(Class<?> clazz, String string) {
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (!string.equals(field.getName())) continue;
                return field;
            }
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        return null;
    }

    public static int getSerializeFeatures(Class<?> object) {
        if ((object = ((Class)object).getAnnotation(JSONType.class)) == null) {
            return 0;
        }
        return SerializerFeature.of(object.serialzeFeatures());
    }

    public static int getParserFeatures(Class<?> object) {
        if ((object = ((Class)object).getAnnotation(JSONType.class)) == null) {
            return 0;
        }
        return Feature.of(object.parseFeatures());
    }

    public static String decapitalize(String object) {
        if (object != null && ((String)object).length() != 0) {
            if (((String)object).length() > 1 && Character.isUpperCase(((String)object).charAt(1)) && Character.isUpperCase(((String)object).charAt(0))) {
                return object;
            }
            char[] cArray = ((String)object).toCharArray();
            object = cArray;
            cArray[0] = Character.toLowerCase(cArray[0]);
            return new String((char[])object);
        }
        return object;
    }

    static void setAccessible(AccessibleObject accessibleObject) {
        if (!setAccessibleEnable) {
            return;
        }
        if (accessibleObject.isAccessible()) {
            return;
        }
        try {
            accessibleObject.setAccessible(true);
            return;
        }
        catch (AccessControlException accessControlException) {
            setAccessibleEnable = false;
            return;
        }
    }

    static {
        TypeUtils.addBaseClassMappings();
    }
}

