/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.pop.util;

import com.qx.wz.exception.WzException;
import com.qx.wz.pop.common.ServerErrorCode;
import com.qx.wz.pop.rpc.result.Result;

public class ApiResultUtil {
    public static void checkApiResult(Result result) {
        if (result != null) {
            ApiResultUtil.checkApiResult(result.getCode(), result.getMessage());
            return;
        }
        throw new WzException(ServerErrorCode.RESULT_IS_NULL.getCode(), "The result gets from server is null.");
    }

    public static void checkApiResult(int n2, String string) {
        if (n2 == 0) {
            return;
        }
        switch (n2) {
            default: {
                throw new WzException(ServerErrorCode.UNKNOWN_ERROR.getCode(), string);
            }
            case 4001: {
                throw new WzException(ServerErrorCode.MISSING_PARAM.getCode(), string);
            }
            case 2001: {
                throw new WzException(ServerErrorCode.TRACK_ID_NOT_EXIST.getCode(), string);
            }
            case 1032: {
                throw new WzException(ServerErrorCode.LOG_INFO_TYPE_NOT_EXIST.getCode(), string);
            }
            case 1031: {
                throw new WzException(ServerErrorCode.LOG_INFO_SAVE_ERROR.getCode(), string);
            }
            case 1030: {
                throw new WzException(ServerErrorCode.LOG_INFO_ALREADY_EXIST.getCode(), string);
            }
            case 1016: {
                throw new WzException(ServerErrorCode.MAX_NTRIP_USER_NUM_ERROR.getCode(), string);
            }
            case 1009: {
                throw new WzException(ServerErrorCode.POP_USER_ID_NOT_MACTH_APP_ID.getCode(), string);
            }
            case -500: 
            case -1: 
            case 5001: 
        }
        throw new WzException(ServerErrorCode.INTERNAL_ERROR.getCode(), string);
    }
}

